/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.impl.loot.modifier;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.datapatched.api.loot.LootModifier;
import dev.worldgen.datapatched.impl.loot.modifier.CommonData;
import dev.worldgen.datapatched.mixin.loot.LootPoolAccessor;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;

public record AddEntries(CommonData commonData, List<LootPoolEntryContainer> entries) implements LootModifier
{
    public static final MapCodec<AddEntries> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CommonData.codec(0).forGetter(AddEntries::commonData), (App)LootPoolEntries.CODEC.listOf().fieldOf("entries").forGetter(AddEntries::entries)).apply((Applicative)instance, AddEntries::new));

    @Override
    public void apply(LootTable table, ResourceLocation key) {
        for (LootPool pool : this.accessor(table).datapatched$getPools()) {
            ImmutableList baseEntries = ImmutableList.builder().addAll(AddEntries.accessor(pool).datapatched$getEntries()).addAll(this.entries).build();
            AddEntries.accessor(pool).datapatched$setEntries((List<LootPoolEntryContainer>)baseEntries);
        }
    }

    private static LootPoolAccessor accessor(LootPool pool) {
        return (LootPoolAccessor)pool;
    }

    @Override
    public MapCodec<? extends LootModifier> codec() {
        return CODEC;
    }
}

