/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.impl.trade.offer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.datapatched.api.trade.SimpleTradeOffer;
import dev.worldgen.datapatched.api.trade.TradeOffer;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;

public record Base(ItemCost buying, Optional<ItemCost> buyingSecondary, ItemStack selling, Optional<LootItemFunction> sellingModifier, int maxUses, int experience, float priceMultiplier) implements SimpleTradeOffer
{
    public static final MapCodec<Base> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BUYING_CODEC.fieldOf("buying").forGetter(Base::buying), (App)BUYING_CODEC.optionalFieldOf("buying_secondary").forGetter(Base::buyingSecondary), (App)SELLING_CODEC.fieldOf("selling").forGetter(Base::selling), (App)LootItemFunctions.ROOT_CODEC.optionalFieldOf("selling_modifier").forGetter(Base::sellingModifier), (App)Codec.INT.fieldOf("max_uses").orElse((Object)12).forGetter(Base::maxUses), (App)Codec.INT.fieldOf("experience").orElse((Object)1).forGetter(Base::experience), (App)Codec.FLOAT.fieldOf("price_multiplier").orElse((Object)Float.valueOf(0.05f)).forGetter(Base::priceMultiplier)).apply((Applicative)instance, Base::new));

    @Override
    public SimpleTradeOffer.ItemTrade createItemTrade(AbstractVillager entity, RandomSource random) {
        return new SimpleTradeOffer.ItemTrade(this.buying, this.buyingSecondary, this.modifyStack(entity, this.selling.copy()));
    }

    private ItemStack modifyStack(AbstractVillager entity, ItemStack original) {
        if (this.sellingModifier.isEmpty()) {
            return original;
        }
        LootContext context = TradeOffer.createContext(entity);
        ItemStack modified = (ItemStack)this.sellingModifier.get().apply((Object)original, (Object)context);
        modified.limitSize(modified.getMaxStackSize());
        return modified;
    }

    @Override
    public MapCodec<? extends TradeOffer> codec() {
        return CODEC;
    }
}

