/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.impl.trade.offer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.datapatched.api.trade.SimpleTradeOffer;
import dev.worldgen.datapatched.api.trade.TradeOffer;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.level.ItemLike;

public record EnchantedBook(Optional<ItemCost> buyingSecondary, HolderSet<Enchantment> enchantments, int minLevel, int maxLevel, int maxUses, int experience, float priceMultiplier) implements SimpleTradeOffer
{
    public static final MapCodec<EnchantedBook> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BUYING_CODEC.optionalFieldOf("buying_secondary").forGetter(EnchantedBook::buyingSecondary), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).fieldOf("enchantments").forGetter(EnchantedBook::enchantments), (App)Codec.intRange((int)1, (int)255).fieldOf("min_level").orElse((Object)1).forGetter(EnchantedBook::minLevel), (App)Codec.intRange((int)1, (int)255).fieldOf("max_level").orElse((Object)255).forGetter(EnchantedBook::maxLevel), (App)Codec.INT.fieldOf("max_uses").orElse((Object)12).forGetter(EnchantedBook::maxUses), (App)Codec.INT.fieldOf("experience").orElse((Object)1).forGetter(EnchantedBook::experience), (App)Codec.FLOAT.fieldOf("price_multiplier").orElse((Object)Float.valueOf(0.2f)).forGetter(EnchantedBook::priceMultiplier)).apply((Applicative)instance, EnchantedBook::new));

    @Override
    public SimpleTradeOffer.ItemTrade createItemTrade(AbstractVillager entity, RandomSource random) {
        int max;
        Optional optional = this.enchantments.getRandomElement(random);
        if (optional.isEmpty()) {
            return null;
        }
        Holder holder = (Holder)optional.get();
        Enchantment enchantment = (Enchantment)holder.value();
        int min = Math.max(this.minLevel, enchantment.getMinLevel());
        int level = min < (max = Math.min(this.maxLevel, enchantment.getMaxLevel())) ? random.nextIntBetweenInclusive(min, max) : min;
        ItemStack book = EnchantedBook.createBook((Holder<Enchantment>)holder, level);
        int emeralds = 2 + random.nextInt(5 + level * 10) + 3 * level;
        if (holder.is(EnchantmentTags.DOUBLE_TRADE_PRICE)) {
            emeralds *= 2;
        }
        if (emeralds > 64) {
            emeralds = 64;
        }
        return new SimpleTradeOffer.ItemTrade(new ItemCost((ItemLike)Items.EMERALD, emeralds), this.buyingSecondary, book);
    }

    private static ItemStack createBook(Holder<Enchantment> holder, int level) {
        ItemStack stack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        stack.enchant(holder, level);
        return stack;
    }

    @Override
    public MapCodec<? extends TradeOffer> codec() {
        return CODEC;
    }
}

