/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.impl.trade.offer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.datapatched.api.trade.TradeOffer;
import dev.worldgen.datapatched.impl.trade.TradeHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.trading.MerchantOffer;

public record TypeSpecific(List<Entry> entries, Holder<TradeOffer> fallback) implements TradeOffer
{
    public static final MapCodec<TypeSpecific> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(TypeSpecific::entries), (App)TradeOffer.ENTRY_CODEC.fieldOf("fallback").orElse((Object)EMPTY).forGetter(TypeSpecific::fallback)).apply((Applicative)instance, TypeSpecific::new));

    public TypeSpecific(Entry ... entries) {
        this(Arrays.stream(entries).toList(), (Holder<TradeOffer>)EMPTY);
    }

    @Override
    public List<MerchantOffer> create(AbstractVillager merchant, RandomSource random) {
        if (merchant instanceof VillagerDataHolder) {
            VillagerDataHolder container = (VillagerDataHolder)merchant;
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.VILLAGER_TYPE, (ResourceLocation)TradeHelper.getType(container.getVillagerData()));
            for (Entry entry : this.entries) {
                if (!entry.types().contains(key)) continue;
                return ((TradeOffer)entry.trade().value()).create(merchant, random);
            }
        }
        return ((TradeOffer)this.fallback.value()).create(merchant, random);
    }

    @SafeVarargs
    public static Entry entry(TradeOffer offer, ResourceKey<VillagerType> ... types) {
        return new Entry((Holder<TradeOffer>)Holder.direct((Object)offer), Arrays.stream(types).toList());
    }

    @Override
    public MapCodec<? extends TradeOffer> codec() {
        return CODEC;
    }

    public record Entry(Holder<TradeOffer> trade, List<ResourceKey<VillagerType>> types) {
        private static final Codec<ResourceKey<VillagerType>> TYPE_CODEC = ResourceKey.codec((ResourceKey)Registries.VILLAGER_TYPE);
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TradeOffer.ENTRY_CODEC.fieldOf("trade").orElse(TradeOffer.EMPTY).forGetter(Entry::trade), (App)Codec.withAlternative((Codec)TYPE_CODEC.listOf(), TYPE_CODEC, List::of).fieldOf("types").forGetter(Entry::types)).apply((Applicative)instance, Entry::new));
    }
}

