/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.mixin.loot;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import dev.worldgen.datapatched.api.DatapatchedRegistries;
import dev.worldgen.datapatched.api.loot.LootModifier;
import dev.worldgen.datapatched.impl.Datapatched;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ReloadableServerRegistries.class})
public class ReloadableServerRegistriesMixin {
    @ModifyReturnValue(method={"method_58279(Lnet/minecraft/world/level/storage/loot/LootDataType;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/RegistryOps;)Lnet/minecraft/core/WritableRegistry;", "lambda$scheduleRegistryLoad$3(Lnet/minecraft/world/level/storage/loot/LootDataType;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/RegistryOps;)Lnet/minecraft/core/WritableRegistry;", "lambda$scheduleElementParse$4(Lnet/minecraft/world/level/storage/loot/LootDataType;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/RegistryOps;)Lnet/minecraft/core/WritableRegistry;", "lambda$scheduleRegistryLoad$5(Lnet/minecraft/world/level/storage/loot/LootDataType;Lnet/minecraft/resources/RegistryOps;Lnet/minecraft/server/packs/resources/ResourceManager;)Lnet/minecraft/core/WritableRegistry;"}, at={@At(value="RETURN")})
    private static WritableRegistry<?> applyLootModifiers(WritableRegistry<?> registry, @Local(ordinal=0, argsOnly=true) LootDataType<?> dataType, @Local(ordinal=0, argsOnly=true) ResourceManager manager, @Local(ordinal=0, argsOnly=true) RegistryOps<Object> ops) {
        Object t;
        if (!dataType.registryKey().equals(Registries.LOOT_TABLE)) {
            return registry;
        }
        Optional getter = ops.getter(DatapatchedRegistries.LOOT_MODIFIER);
        if (getter.isPresent() && (t = getter.get()) instanceof HolderLookup) {
            HolderLookup lookup = (HolderLookup)t;
            ArrayList modifiers = new ArrayList(lookup.listElements().toList());
            modifiers.sort(Comparator.comparingInt(holder -> ((LootModifier)holder.value()).commonData().priority()));
            for (ResourceLocation id : registry.keySet()) {
                LootTable table = (LootTable)registry.getOptional(id).get();
                for (Holder.Reference modifier : modifiers) {
                    ((LootModifier)modifier.value()).tryApply(table, id);
                }
            }
        } else {
            Datapatched.LOGGER.error("Couldn't get loot modifier registry, not applying loot modifiers :(");
        }
        return registry;
    }
}

