/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.api.trade;

import dev.worldgen.datapatched.api.trade.TradeOffer;
import dev.worldgen.datapatched.impl.trade.offer.Base;
import dev.worldgen.datapatched.impl.trade.offer.EnchantedItem;
import dev.worldgen.datapatched.impl.trade.offer.TypeSpecific;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_9306;

public class TradeOfferBuilder {
    public static final List<String> LEVEL_TO_NAME = List.of("novice", "apprentice", "journeyman", "expert", "master");

    public static TradeOffer itemsForEmeralds(class_1935 selling, int emeraldCount, int sellingCount, int maxUses) {
        return TradeOfferBuilder.itemsForEmeralds(selling, emeraldCount, sellingCount, maxUses, 1);
    }

    public static TradeOffer itemsForEmeralds(class_1935 selling, int emeraldCount, int sellingCount, int maxUses, int xp) {
        return TradeOfferBuilder.itemsForEmeralds(selling, emeraldCount, sellingCount, maxUses, xp, 0.05f);
    }

    public static TradeOffer itemsForEmeralds(class_1935 selling, int emeraldCount, int sellingCount, int maxUses, int xp, float priceMultiplier) {
        return TradeOfferBuilder.itemsForEmeralds(new class_1799(selling, sellingCount), emeraldCount, maxUses, xp, priceMultiplier);
    }

    public static TradeOffer itemsForEmeralds(class_1799 selling, int emeraldCount, int maxUses, int xp, float priceMultiplier) {
        return new Base(new class_9306((class_1935)class_1802.field_8687, emeraldCount), Optional.empty(), selling, Optional.empty(), maxUses, xp, priceMultiplier);
    }

    public static TradeOffer itemsAndEmeraldsForItems(class_1935 buying, int count, int emeraldCount, class_1935 selling, int maxUses, int xp) {
        return TradeOfferBuilder.itemsAndEmeraldsForItems(new class_9306(buying, count), emeraldCount, new class_1799(selling, count), maxUses, xp);
    }

    public static TradeOffer itemsAndEmeraldsForItems(class_9306 buying, int emeraldCount, class_1799 selling, int maxUses, int xp) {
        return new Base(buying, Optional.of(new class_9306((class_1935)class_1802.field_8687, emeraldCount)), selling, Optional.empty(), maxUses, xp, 0.05f);
    }

    public static TradeOffer emeraldsForItems(class_1935 buying, int buyingCount, int maxUses, int xp) {
        return TradeOfferBuilder.emeraldsForItems(new class_9306(buying, buyingCount), 1, maxUses, xp);
    }

    public static TradeOffer emeraldsForItems(class_1935 buying, int buyingCount, int emeraldCount, int maxUses, int xp) {
        return TradeOfferBuilder.emeraldsForItems(new class_9306(buying, buyingCount), emeraldCount, maxUses, xp);
    }

    public static TradeOffer emeraldsForItems(class_9306 buying, int emeraldCount, int maxUses, int xp) {
        return new Base(buying, Optional.empty(), new class_1799((class_1935)class_1802.field_8687, emeraldCount), Optional.empty(), maxUses, xp, 0.05f);
    }

    public static TradeOffer enchantedItem(class_1935 selling, int emeraldCount, int maxUses, int xp, float priceMultiplier) {
        return new EnchantedItem(new class_9306((class_1935)class_1802.field_8687, emeraldCount), selling, maxUses, xp, priceMultiplier);
    }

    @SafeVarargs
    public static TradeOffer typeSpecific(TradeOffer offer, class_5321<class_3854> ... types) {
        return new TypeSpecific(TypeSpecific.entry(offer, types));
    }
}

