/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.impl.trade.offer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.datapatched.api.trade.SimpleTradeOffer;
import dev.worldgen.datapatched.api.trade.TradeOffer;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_3988;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_9306;
import net.minecraft.class_9636;

public record EnchantedBook(Optional<class_9306> buyingSecondary, class_6885<class_1887> enchantments, int minLevel, int maxLevel, int maxUses, int experience, float priceMultiplier) implements SimpleTradeOffer
{
    public static final MapCodec<EnchantedBook> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BUYING_CODEC.optionalFieldOf("buying_secondary").forGetter(EnchantedBook::buyingSecondary), (App)class_6895.method_40340((class_5321)class_7924.field_41265).fieldOf("enchantments").forGetter(EnchantedBook::enchantments), (App)Codec.intRange((int)1, (int)255).fieldOf("min_level").orElse((Object)1).forGetter(EnchantedBook::minLevel), (App)Codec.intRange((int)1, (int)255).fieldOf("max_level").orElse((Object)255).forGetter(EnchantedBook::maxLevel), (App)Codec.INT.fieldOf("max_uses").orElse((Object)12).forGetter(EnchantedBook::maxUses), (App)Codec.INT.fieldOf("experience").orElse((Object)1).forGetter(EnchantedBook::experience), (App)Codec.FLOAT.fieldOf("price_multiplier").orElse((Object)Float.valueOf(0.2f)).forGetter(EnchantedBook::priceMultiplier)).apply((Applicative)instance, EnchantedBook::new));

    @Override
    public SimpleTradeOffer.ItemTrade createItemTrade(class_3988 entity, class_5819 random) {
        int max;
        Optional optional = this.enchantments.method_40243(random);
        if (optional.isEmpty()) {
            return null;
        }
        class_6880 holder = (class_6880)optional.get();
        class_1887 enchantment = (class_1887)holder.comp_349();
        int min = Math.max(this.minLevel, enchantment.method_8187());
        int level = min < (max = Math.min(this.maxLevel, enchantment.method_8183())) ? random.method_39332(min, max) : min;
        class_1799 book = EnchantedBook.createBook((class_6880<class_1887>)holder, level);
        int emeralds = 2 + random.method_43048(5 + level * 10) + 3 * level;
        if (holder.method_40220(class_9636.field_51546)) {
            emeralds *= 2;
        }
        if (emeralds > 64) {
            emeralds = 64;
        }
        return new SimpleTradeOffer.ItemTrade(new class_9306((class_1935)class_1802.field_8687, emeralds), this.buyingSecondary, book);
    }

    private static class_1799 createBook(class_6880<class_1887> holder, int level) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8598);
        stack.method_7978(holder, level);
        return stack;
    }

    @Override
    public MapCodec<? extends TradeOffer> codec() {
        return CODEC;
    }
}

