/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.impl.trade.offer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.datapatched.api.trade.SimpleTradeOffer;
import dev.worldgen.datapatched.api.trade.TradeOffer;
import java.util.Optional;
import net.minecraft.class_117;
import net.minecraft.class_131;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_3988;
import net.minecraft.class_47;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6497;
import net.minecraft.class_7924;
import net.minecraft.class_9306;
import net.minecraft.class_9636;

public record EnchantedItem(class_9306 buying, Optional<class_9306> buyingSecondary, class_1799 selling, Optional<class_117> sellingModifier, class_6497<Integer> levels, int maxUses, int experience, float priceMultiplier) implements SimpleTradeOffer
{
    public static final class_6497<Integer> DEFAULT_LEVELS = new class_6497((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(19));
    public static final MapCodec<EnchantedItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BUYING_CODEC.fieldOf("buying").forGetter(EnchantedItem::buying), (App)BUYING_CODEC.optionalFieldOf("buying_secondary").forGetter(EnchantedItem::buyingSecondary), (App)class_1799.field_49267.fieldOf("selling").forGetter(EnchantedItem::selling), (App)class_131.field_50023.optionalFieldOf("selling_modifier").forGetter(EnchantedItem::sellingModifier), (App)class_6497.field_34390.fieldOf("levels").orElse(DEFAULT_LEVELS).forGetter(EnchantedItem::levels), (App)Codec.INT.fieldOf("max_uses").orElse((Object)12).forGetter(EnchantedItem::maxUses), (App)Codec.INT.fieldOf("experience").orElse((Object)1).forGetter(EnchantedItem::experience), (App)Codec.FLOAT.fieldOf("price_multiplier").orElse((Object)Float.valueOf(0.05f)).forGetter(EnchantedItem::priceMultiplier)).apply((Applicative)instance, EnchantedItem::new));

    public EnchantedItem(class_9306 buying, class_1935 selling, int maxUses, int xp, float priceMultiplier) {
        this(buying, Optional.empty(), new class_1799(selling), Optional.empty(), DEFAULT_LEVELS, maxUses, xp, priceMultiplier);
    }

    @Override
    public SimpleTradeOffer.ItemTrade createItemTrade(class_3988 entity, class_5819 random) {
        int level = random.method_39332(((Integer)this.levels.comp_1()).intValue(), ((Integer)this.levels.comp_2()).intValue());
        class_5455 registries = entity.method_56673();
        Optional optional = registries.method_46762(class_7924.field_41265).method_46733(class_9636.field_51549);
        class_9306 finalBuying = new class_9306((class_1935)this.buying.comp_2424().comp_349(), this.buying.comp_2425() + level);
        class_1799 finalSelling = class_1890.method_60133((class_5819)random, (class_1799)this.selling.method_7972(), (int)level, (class_5455)registries, (Optional)optional);
        return new SimpleTradeOffer.ItemTrade(finalBuying, this.buyingSecondary, this.modifyStack(entity, finalSelling));
    }

    private class_1799 modifyStack(class_3988 entity, class_1799 original) {
        if (this.sellingModifier.isEmpty()) {
            return original;
        }
        class_47 context = TradeOffer.createContext(entity);
        class_1799 modified = (class_1799)this.sellingModifier.get().apply((Object)original, (Object)context);
        modified.method_58408(modified.method_7914());
        return modified;
    }

    @Override
    public MapCodec<? extends TradeOffer> codec() {
        return CODEC;
    }
}

