/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lootpatched.impl.modifier;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lootpatched.api.LootModifier;
import dev.worldgen.lootpatched.impl.mixin.LootPoolAccessor;
import dev.worldgen.lootpatched.impl.modifier.CommonData;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;

public record AddEntries(CommonData commonData, List<LootPoolEntryContainer> entries) implements LootModifier
{
    public static final MapCodec<AddEntries> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CommonData.codec(0).forGetter(AddEntries::commonData), (App)LootPoolEntries.CODEC.listOf().fieldOf("entries").forGetter(AddEntries::entries)).apply((Applicative)instance, AddEntries::new));

    @Override
    public void apply(LootTable table, ResourceLocation key) {
        List<LootPool> pools = this.accessor(table).lootpatched$getPools();
        for (LootPool pool : pools) {
            ImmutableList baseEntries = ImmutableList.builder().addAll(AddEntries.accessor(pool).lootpatched$getEntries()).addAll(this.entries).build();
            AddEntries.accessor(pool).lootpatched$setEntries((List<LootPoolEntryContainer>)baseEntries);
        }
    }

    private static LootPoolAccessor accessor(LootPool pool) {
        return (LootPoolAccessor)pool;
    }

    @Override
    public MapCodec<? extends LootModifier> codec() {
        return CODEC;
    }
}

