/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.api.trade;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.worldgen.datapatched.api.DatapatchedBuiltInRegistries;
import dev.worldgen.datapatched.api.DatapatchedRegistries;
import dev.worldgen.datapatched.impl.trade.offer.Empty;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public interface TradeOffer {
    public static final Codec<TradeOffer> CODEC = DatapatchedBuiltInRegistries.TRADE_OFFER_TYPE.byNameCodec().dispatch(TradeOffer::codec, Function.identity());
    public static final Codec<Holder<TradeOffer>> ENTRY_CODEC = RegistryFileCodec.create(DatapatchedRegistries.TRADE_OFFER, CODEC);
    public static final Codec<HolderSet<TradeOffer>> LIST_CODEC = RegistryCodecs.homogeneousList(DatapatchedRegistries.TRADE_OFFER, CODEC, (boolean)false);
    public static final Codec<ItemCost> BUYING_CODEC = Codec.withAlternative((Codec)ItemCost.CODEC, (Codec)ItemStack.SIMPLE_ITEM_CODEC, item -> new ItemCost((ItemLike)item.getItem()));
    public static final Codec<ItemStack> SELLING_CODEC = Codec.withAlternative((Codec)ItemStack.CODEC, (Codec)ItemStack.SIMPLE_ITEM_CODEC, t -> t);
    public static final Holder<TradeOffer> EMPTY = Holder.direct((Object)new Empty());

    public List<MerchantOffer> create(AbstractVillager var1, RandomSource var2);

    public MapCodec<? extends TradeOffer> codec();

    public static LootContext createContext(AbstractVillager entity) {
        LootParams worldContext = new LootParams.Builder((ServerLevel)entity.level()).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)entity).create(LootContextParamSets.COMMAND);
        return new LootContext.Builder(worldContext).create(Optional.empty());
    }
}

