/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.impl.loot.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class ApplyDyesFunction
extends LootItemConditionalFunction {
    public static final MapCodec<ApplyDyesFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> ApplyDyesFunction.commonFields((RecordCodecBuilder.Instance)instance).and((App)Entry.CODEC.listOf().fieldOf("dyes").forGetter(ApplyDyesFunction::entries)).apply((Applicative)instance, ApplyDyesFunction::new));
    public static final LootItemFunctionType<ApplyDyesFunction> TYPE = new LootItemFunctionType(CODEC);
    private final List<Entry> entries;

    public ApplyDyesFunction(List<LootItemCondition> conditions, List<Entry> entries) {
        super(conditions);
        this.entries = entries;
    }

    public LootItemFunctionType<ApplyDyesFunction> getType() {
        return TYPE;
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (!stack.is(ItemTags.DYEABLE)) {
            return stack;
        }
        ArrayList<DyeItem> dyes = new ArrayList<DyeItem>();
        for (Entry entry : this.entries) {
            List<DyeColor> colors = entry.dyes.orElse(Arrays.stream(DyeColor.values()).toList());
            dyes.add(DyeItem.byColor((DyeColor)((DyeColor)Util.getRandom(colors, (RandomSource)context.getRandom()))));
        }
        return DyedItemColor.applyDyes((ItemStack)stack, dyes);
    }

    public static Entry entry(float chance) {
        return new Entry(Optional.empty(), chance);
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public record Entry(Optional<List<DyeColor>> dyes, float chance) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DyeColor.CODEC.listOf().optionalFieldOf("dyes").forGetter(Entry::dyes), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(Entry::chance)).apply((Applicative)instance, Entry::new));
    }
}

