/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.impl.trade.offer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.datapatched.api.trade.SimpleTradeOffer;
import dev.worldgen.datapatched.api.trade.TradeOffer;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;

public record EnchantedItem(ItemCost buying, Optional<ItemCost> buyingSecondary, ItemStack selling, Optional<LootItemFunction> sellingModifier, InclusiveRange<Integer> levels, int maxUses, int experience, float priceMultiplier) implements SimpleTradeOffer
{
    public static final InclusiveRange<Integer> DEFAULT_LEVELS = new InclusiveRange((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(19));
    public static final MapCodec<EnchantedItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BUYING_CODEC.fieldOf("buying").forGetter(EnchantedItem::buying), (App)BUYING_CODEC.optionalFieldOf("buying_secondary").forGetter(EnchantedItem::buyingSecondary), (App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("selling").forGetter(EnchantedItem::selling), (App)LootItemFunctions.ROOT_CODEC.optionalFieldOf("selling_modifier").forGetter(EnchantedItem::sellingModifier), (App)InclusiveRange.INT.fieldOf("levels").orElse(DEFAULT_LEVELS).forGetter(EnchantedItem::levels), (App)Codec.INT.fieldOf("max_uses").orElse((Object)12).forGetter(EnchantedItem::maxUses), (App)Codec.INT.fieldOf("experience").orElse((Object)1).forGetter(EnchantedItem::experience), (App)Codec.FLOAT.fieldOf("price_multiplier").orElse((Object)Float.valueOf(0.05f)).forGetter(EnchantedItem::priceMultiplier)).apply((Applicative)instance, EnchantedItem::new));

    public EnchantedItem(ItemCost buying, ItemLike selling, int maxUses, int xp, float priceMultiplier) {
        this(buying, Optional.empty(), new ItemStack(selling), Optional.empty(), DEFAULT_LEVELS, maxUses, xp, priceMultiplier);
    }

    @Override
    public SimpleTradeOffer.ItemTrade createItemTrade(AbstractVillager entity, RandomSource random) {
        int level = random.nextIntBetweenInclusive(((Integer)this.levels.minInclusive()).intValue(), ((Integer)this.levels.maxInclusive()).intValue());
        RegistryAccess registries = entity.registryAccess();
        Optional optional = registries.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.ON_TRADED_EQUIPMENT);
        ItemCost finalBuying = new ItemCost((ItemLike)this.buying.item().value(), this.buying.count() + level);
        ItemStack finalSelling = EnchantmentHelper.enchantItem((RandomSource)random, (ItemStack)this.selling.copy(), (int)level, (RegistryAccess)registries, (Optional)optional);
        return new SimpleTradeOffer.ItemTrade(finalBuying, this.buyingSecondary, this.modifyStack(entity, finalSelling));
    }

    private ItemStack modifyStack(AbstractVillager entity, ItemStack original) {
        if (this.sellingModifier.isEmpty()) {
            return original;
        }
        LootContext context = TradeOffer.createContext(entity);
        ItemStack modified = (ItemStack)this.sellingModifier.get().apply((Object)original, (Object)context);
        modified.limitSize(modified.getMaxStackSize());
        return modified;
    }

    @Override
    public MapCodec<? extends TradeOffer> codec() {
        return CODEC;
    }
}

