/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.impl.trade.provider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.datapatched.api.DatapatchedRegistries;
import dev.worldgen.datapatched.api.trade.TradeOffer;
import dev.worldgen.datapatched.impl.Datapatched;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public record TradeOfferProvider(List<TradeTier> tiers, boolean overrideModdedTrades) {
    public static final Codec<TradeOfferProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TradeTier.CODEC.listOf().fieldOf("trade_tiers").forGetter(TradeOfferProvider::tiers), (App)Codec.BOOL.fieldOf("override_modded_trades").orElse((Object)false).forGetter(TradeOfferProvider::overrideModdedTrades)).apply((Applicative)instance, TradeOfferProvider::new));

    public TradeOfferProvider(List<TradeTier> tiers) {
        this(tiers, false);
    }

    public static Optional<TradeOfferProvider> getProvider(RegistryAccess registries, ResourceLocation id) {
        if (id.getNamespace().equals("minecraft")) {
            id = ResourceLocation.fromNamespaceAndPath((String)"datapatched", (String)id.getPath());
        }
        return Datapatched.registry(registries, DatapatchedRegistries.TRADE_OFFER_PROVIDER).getOptional(id);
    }

    public record TradeTier(int count, HolderSet<TradeOffer> trades) {
        public static final Codec<TradeTier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("count").forGetter(TradeTier::count), (App)TradeOffer.LIST_CODEC.fieldOf("entries").forGetter(TradeTier::trades)).apply((Applicative)instance, TradeTier::new));
    }
}

