/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.mixin.trade;

import dev.worldgen.datapatched.impl.trade.TradeHelper;
import dev.worldgen.datapatched.impl.trade.provider.TradeOfferProvider;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.flag.FeatureFlags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin {
    @Inject(at={@At(value="HEAD")}, method={"updateTrades"}, cancellable=true)
    private void sellcraft$injectSellcraftTrades(CallbackInfo ci) {
        Villager $this = (Villager)this;
        VillagerData data = $this.getVillagerData();
        ResourceLocation id = TradeHelper.getProfession(data);
        ResourceKey profession = ResourceKey.create((ResourceKey)Registries.VILLAGER_PROFESSION, (ResourceLocation)id);
        Optional<TradeOfferProvider> optional = TradeOfferProvider.getProvider($this.registryAccess(), profession.location());
        if (optional.isEmpty()) {
            return;
        }
        TradeOfferProvider provider = optional.get();
        int level = TradeHelper.getLevel(data);
        if (level <= provider.tiers().size()) {
            VillagerTrades.ItemListing[] moddedTierTrades = new VillagerTrades.ItemListing[]{};
            if (!provider.overrideModdedTrades()) {
                Int2ObjectMap experimentalModdedTrades;
                Int2ObjectMap moddedFullTrades = $this.level().enabledFeatures().contains(FeatureFlags.TRADE_REBALANCE) ? ((experimentalModdedTrades = (Int2ObjectMap)VillagerTrades.EXPERIMENTAL_TRADES.get(profession)) != null ? experimentalModdedTrades : (Int2ObjectMap)VillagerTrades.TRADES.get(profession)) : (Int2ObjectMap)VillagerTrades.TRADES.get(profession);
                moddedTierTrades = (VillagerTrades.ItemListing[])moddedFullTrades.get(level);
            }
            TradeOfferProvider.TradeTier tradeTier = provider.tiers().get(level - 1);
            TradeHelper.addDatapatchedTrades((AbstractVillager)$this, $this.getOffers(), tradeTier, moddedTierTrades);
            ci.cancel();
        }
    }
}

