/*
 * Decompiled with CFR 0.152.
 */
package com.mochi_753.eraser.item;

import com.mochi_753.eraser.EraserConfig;
import com.mochi_753.eraser.util.EraserHandler;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EraserItem
extends Item {
    public EraserItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!player.m_9236_().m_5776_() && !target.m_9236_().m_5776_()) {
            this.eraseLivingEntity(target, player);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.m_5776_() && player.m_6047_()) {
            double eraseRadius = (Double)EraserConfig.COMMON.eraseRadius.get();
            List targets = player.m_9236_().m_6443_(LivingEntity.class, player.m_20191_().m_82400_(eraseRadius), p -> p != player);
            targets.forEach(target -> this.eraseLivingEntity((LivingEntity)target, player));
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    protected void eraseLivingEntity(LivingEntity target, Player player) {
        EraserHandler.playSound(target, target.m_9236_());
        if (target instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)target;
            EraserHandler.disconnectPlayer(serverPlayer, player);
        } else {
            EraserHandler.eraseNonPlayerEntity(target, player, true);
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)EraserConfig.COMMON.eraserDurability.get();
    }
}

