/*
 * Decompiled with CFR 0.152.
 */
package com.mochi_753.eraser.item;

import com.mochi_753.eraser.EraserConfig;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class EraserItemBase
extends Item {
    public EraserItemBase(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_6047_()) {
            ItemStack stack = player.m_21120_(hand);
            double eraseRadius = (Double)EraserConfig.COMMON.eraseRadius.get();
            List targets = player.m_9236_().m_6443_(LivingEntity.class, player.m_20191_().m_82400_(eraseRadius), e -> e != player);
            targets.forEach(livingEntity -> this.eraseLivingEntity((LivingEntity)livingEntity, player, level));
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    @NotNull
    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        this.eraseLivingEntity(target, player, player.m_9236_());
        return InteractionResult.SUCCESS;
    }

    protected void eraseLivingEntity(LivingEntity target, Player player, Level level) {
        if (level.m_5776_()) {
            return;
        }
        this.playEraseSound(target, level);
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            if (targetPlayer instanceof ServerPlayer) {
                ServerPlayer targetServerPlayer = (ServerPlayer)targetPlayer;
                this.erasePlayer(player, targetPlayer, targetServerPlayer);
            }
        } else {
            target.m_142687_(Entity.RemovalReason.DISCARDED);
            if (target.m_6084_()) {
                this.forceErase(target, player);
            }
        }
    }

    protected void erasePlayer(Player player, Player targetPlayer, ServerPlayer targetServerPlayer) {
        if (((Boolean)EraserConfig.COMMON.allowErasePlayer.get()).booleanValue()) {
            targetServerPlayer.f_8906_.m_9942_((Component)Component.m_237115_((String)"message.eraser.disconnect"));
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"message.eraser.cannot_use"), true);
        }
    }

    protected void forceErase(LivingEntity target, Player player) {
        ResourceKey erasedKey;
        ServerLevel serverLevel;
        MinecraftServer server;
        ServerLevel erasedWorld;
        player.m_5661_((Component)Component.m_237113_((String)"Erased by force"), true);
        player.m_5661_((Component)Component.m_237115_((String)"message.eraser.re_login"), false);
        Level level = target.m_9236_();
        if (level instanceof ServerLevel && (erasedWorld = (server = (serverLevel = (ServerLevel)level).m_7654_()).m_129880_(erasedKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("eraser", "erased")))) != null) {
            target.m_5489_(erasedWorld);
            target.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
    }

    protected void playEraseSound(LivingEntity target, Level level) {
        level.m_5594_(null, target.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

