/*
 * Decompiled with CFR 0.152.
 */
package com.mochi_753.eraser;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class EraserConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue allowDisconnectPlayer;
        public final ForgeConfigSpec.BooleanValue allowCrashClient;
        public final ForgeConfigSpec.DoubleValue eraseRadius;
        public final ForgeConfigSpec.IntValue eraserDurability;
        public final ForgeConfigSpec.IntValue setHealthSpamCount;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("EraserMOD config settings").push("general");
            this.allowDisconnectPlayer = builder.comment("Should the Eraser be able to disconnect players?").define("allowDisconnectPlayer", false);
            this.allowCrashClient = builder.comment("Should the Eraser be able to crash clients?").define("allowCrashClient", false);
            this.eraseRadius = builder.comment("Radius for crouch-right-click erase.json (blocks)").defineInRange("eraseRadius", 4.0, 1.0, 64.0);
            this.eraserDurability = builder.comment("Eraser durability").defineInRange("eraserDurability", 100, 1, Integer.MAX_VALUE);
            this.setHealthSpamCount = builder.comment("Repetition count for setHealth(0) spam. For those enemies who think 0 HP still means \"I'm fine\".").defineInRange("setHealthSpamCount", 10, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

