/*
 * Decompiled with CFR 0.152.
 */
package com.mochi_753.eraser.item;

import com.mochi_753.eraser.util.EraserHandler;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TestItem
extends Item {
    private static final String[] MODES = new String[]{"Crash", "Disconnect", "Respawn"};
    private static final String TAG_MODE = "ModeIndex";

    public TestItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int modeIndex = this.getMode(stack);
            if (player.m_6047_()) {
                modeIndex = (modeIndex + 1) % MODES.length;
                this.setMode(stack, modeIndex);
                player.m_5661_((Component)Component.m_237113_((String)("Mode changed to " + MODES[modeIndex])), false);
            } else {
                switch (modeIndex) {
                    case 0: {
                        EraserHandler.crashClient(serverPlayer, player);
                        break;
                    }
                    case 1: {
                        EraserHandler.disconnectPlayer(serverPlayer, player);
                        break;
                    }
                    case 2: {
                        EraserHandler.respawnPlayer(serverPlayer, player);
                    }
                }
            }
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)("Mode: " + MODES[this.getMode(stack)])));
    }

    private int getMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(TAG_MODE) ? tag.m_128451_(TAG_MODE) : 0;
    }

    private void setMode(ItemStack stack, int mode) {
        stack.m_41784_().m_128405_(TAG_MODE, mode);
    }
}

