/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.lemonade.config;

import cc.cassian.lemonade.Lemonade;
import cc.cassian.lemonade.config.fabric.ModConfigImpl;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static ModConfig INSTANCE = new ModConfig();
    public boolean grindstone_workstation = false;
    public boolean search_containers = true;
    public boolean campfires_start_lit = true;
    public boolean stoves_start_lit = true;
    public boolean tools_sticks_start_fires = false;
    public int tools_durability_multiplier = 1;
    public float tools_speed_multiplier = 1.0f;
    public boolean vanilla_clean_maps = false;
    public boolean vanilla_leather_horse_armour_is_lightweight = false;
    public boolean vanilla_piglins_zombify = true;
    public boolean tooltips_enable = true;
    public boolean vanilla_nether_portals = true;
    public String tooltips_icon_damage = "diamond_sword";
    public String tooltips_icon_speed = "feather";
    public String tooltips_icon_armor = "iron_chestplate";
    public String tooltips_icon_toughness = "diamond_chestplate";
    public boolean lemon_sorbet = false;
    public String potions_awkward_potion_reagent = "minecraft:nether_wart";
    public String potions_fuel = "minecraft:blaze_powder";
    public boolean attributes_enable = true;
    public float attributes_attack_damage = 1.0f;
    public float attributes_movement_speed = 0.1f;
    public float attributes_jumping_movement_speed = 0.02f;
    public float attributes_sprint_jumping_movement_speed = 0.026f;
    public float attributes_sneaking_movement_speed = 0.3f;
    public float attributes_block_interaction_range = 4.5f;
    public float attributes_entity_interaction_range = 3.0f;
    public boolean vanilla_reusable_templates = false;

    public static void load() {
        if (!Files.exists(ModConfig.configPath(), new LinkOption[0])) {
            ModConfig.save();
            return;
        }
        try (InputStream input = Files.newInputStream(ModConfig.configPath(), new OpenOption[0]);){
            INSTANCE = (ModConfig)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), ModConfig.class);
        }
        catch (IOException e) {
            Lemonade.LOGGER.warn("Unable to load config file!");
        }
    }

    public static void save() {
        try (OutputStream output = Files.newOutputStream(ModConfig.configPath(), new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            Lemonade.LOGGER.warn("Unable to save config file!");
        }
    }

    public static ModConfig get() {
        if (INSTANCE == null) {
            INSTANCE = new ModConfig();
        }
        return INSTANCE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path configPath() {
        return ModConfigImpl.configPath();
    }
}

