package cc.cassian.lemonade;

import cc.cassian.lemonade.compat.ModCompat;
import cc.cassian.lemonade.compat.TotallyLitCompat;
import cc.cassian.lemonade.compat.eiv.LemonadeEIVPlugin;
import cc.cassian.lemonade.config.ModConfig;
import cc.cassian.lemonade.core.LemonadeCauldronInteractions;
import cc.cassian.lemonade.core.LemonadeDefaultComponents;
import cc.cassian.lemonade.core.LemonadeItemGroups;
import cc.cassian.lemonade.recipe.LemonadeRecipes;
import cc.cassian.lemonade.registry.LemonadeBlocks;
import cc.cassian.lemonade.registry.LemonadeItems;
import cc.cassian.lemonade.registry.LemonadeMobEffects;
import net.fabricmc.api.ModInitializer;

import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lemonade implements ModInitializer {
	public static final String MOD_ID = "lemonade";
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
	public static final ModConfig CONFIG = ModConfig.createToml(FabricLoader.getInstance().getConfigDir(), "", MOD_ID, ModConfig.class);

	public static class_2960 of(String name) {
		return class_2960.method_60655(MOD_ID, name);
	}

    @Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.

		LOGGER.info("Everything tastes better with Lemonade!");
        if (Lemonade.CONFIG.lemonade.content) {
            LemonadeBlocks.touch();
		    LemonadeItems.touch();
            LemonadeItemGroups.register();
            LemonadeMobEffects.touch();
        }
        if (Lemonade.CONFIG.lemonade.cauldronInteractions)
            LemonadeCauldronInteractions.register();
		if (ModCompat.EIV) {
			CommonLifecycleEvents.TAGS_LOADED.register(((registryAccess, b) -> {
				LemonadeEIVPlugin.hideStacks();
			}));
		}
        if (Lemonade.CONFIG.lemonade.changeDefaultComponents)
		    LemonadeDefaultComponents.register();
        if (Lemonade.CONFIG.lemonade.grindstone_workstation) {
            LemonadeRecipes.touch();
        }
        if (Lemonade.CONFIG.lemonade.content) {
            ResourceManagerHelper.registerBuiltinResourcePack(
                    Lemonade.of("content"),
                    FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(),
                    ResourcePackActivationType.ALWAYS_ENABLED);
        }
        if (Lemonade.CONFIG.contentPacks.worldgen) {
            ResourceManagerHelper.registerBuiltinResourcePack(
                    Lemonade.of("worldgen"),
                    FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(),
                    ResourcePackActivationType.ALWAYS_ENABLED);
        }
        if (Lemonade.CONFIG.contentPacks.refreshment) {
            ResourceManagerHelper.registerBuiltinResourcePack(
                    Lemonade.of("refreshment"),
                    FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(),
                    ResourcePackActivationType.ALWAYS_ENABLED);
        }
        if (Lemonade.CONFIG.contentPacks.tomes) {
            ResourceManagerHelper.registerBuiltinResourcePack(
                    Lemonade.of("tomes"),
                    FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(),
                    ResourcePackActivationType.ALWAYS_ENABLED);
        }
        if (Lemonade.CONFIG.lemonade.lemon_zest) {
            ResourceManagerHelper.registerBuiltinResourcePack(
                    Lemonade.of("lemon_sorbet"),
                    FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(),
                    ResourcePackActivationType.ALWAYS_ENABLED);
        }
		if (ModCompat.TOTALLY_LIT) {
			TotallyLitCompat.registerEvents();
		}
        FlammableBlockRegistry.getDefaultInstance().add(class_2246.field_10343, 15, 100);
	}
}