package cc.cassian.lemonade.blocks;

import cc.cassian.lemonade.registry.LemonadeItems;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class StickBlock extends class_2341 {

    @Override
    protected class_1269 method_55765(
            class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult
    ) {
        class_1304 slot;
        if (interactionHand.equals(class_1268.field_5808)) slot = class_1304.field_6173;
        else slot = class_1304.field_6171;
        if (itemStack.method_31574(class_1802.field_8884)) {
            if (blockState.method_11654(field_11007).equals(class_2738.field_12471))
                level.method_8652(blockPos, class_2246.field_10099.method_9564().method_11657(field_11177, blockState.method_11654(field_11177)), 4);
            else
                level.method_8652(blockPos, class_2246.field_10336.method_34725(blockState), 4);
            itemStack.method_7970(1, player, slot);
            return class_1269.field_5812;
        }
        if (itemStack.method_31574(class_1802.field_8814)) {
            if (blockState.method_11654(field_11007).equals(class_2738.field_12471))
                level.method_8652(blockPos, class_2246.field_10099.method_9564().method_11657(field_11177, blockState.method_11654(field_11177)), 4);
            else
                level.method_8652(blockPos, class_2246.field_10336.method_34725(blockState), 4);
            itemStack.method_7939(itemStack.method_7947()-1);
            return class_1269.field_5812;
        }
        else if (itemStack.method_31574(LemonadeItems.SOUL_STRIKER)) {
            if (blockState.method_11654(field_11007).equals(class_2738.field_12471))
                level.method_8652(blockPos, class_2246.field_22093.method_9564().method_11657(field_11177, blockState.method_11654(field_11177)), 4);
            else
                level.method_8652(blockPos, class_2246.field_22092.method_34725(blockState), 4);
            itemStack.method_7970(1, player, slot);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(field_11007)) {
            case field_12475 -> class_2248.method_9541(6.0, 0.0, 6.0, 10.0, 10.0, 10.0);
            case field_12471 -> getBoundingShape(state);
            //Ceiling
            default -> class_2248.method_9541(6.0, 8.0, 6.0, 10.0, 16.0, 10.0);
        };
    }

    public StickBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_11007, field_11177);
    }

    @Override
    protected MapCodec<? extends class_2341> method_53969() {
        return null;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return canPlaceAt(world, pos, method_10119(state).method_10153());
    }

    public static boolean canPlaceAt(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction);
        return world.method_8320(blockPos).method_26206(world, blockPos, direction.method_10153()) | method_20044(world, pos.method_10074(), class_2350.field_11036);
    }


    private static final Map<class_2350, class_265> WALL_BOUNDING_SHAPES;
    public static class_265 getBoundingShape(class_2680 state) {
        return WALL_BOUNDING_SHAPES.get(state.method_11654(field_11177));
    }
    static {
        WALL_BOUNDING_SHAPES = Maps.newEnumMap(ImmutableMap.of(class_2350.field_11043, class_2248.method_9541(5.5, 3.0, 11.0, 10.5, 13.0, 16.0), class_2350.field_11035, class_2248.method_9541(5.5, 3.0, 0.0, 10.5, 13.0, 5.0), class_2350.field_11039, class_2248.method_9541(11.0, 3.0, 5.5, 16.0, 13.0, 10.5), class_2350.field_11034, class_2248.method_9541(0.0, 3.0, 5.5, 5.0, 13.0, 10.5)));
    }


}