package cc.cassian.lemonade.compat.eiv;

import cc.cassian.item_descriptions.client.DescriptionKey;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import cc.cassian.lemonade.Lemonade;
import cc.cassian.lemonade.compat.ItemDescriptionsCompat;
import cc.cassian.lemonade.compat.ModCompat;
import cc.cassian.lemonade.compat.eiv.info.InfoServerRecipe;
import cc.cassian.lemonade.compat.eiv.info.InfoViewRecipe;
import cc.cassian.lemonade.compat.eiv.interaction.WorldInteractionServerRecipe;
import cc.cassian.lemonade.compat.eiv.interaction.WorldInteractionViewRecipe;
import cc.cassian.lemonade.recipe.LemonadeRecipes;
import de.crafty.eiv.common.api.IExtendedItemViewIntegration;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_10594;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_1856;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2521;
import net.minecraft.class_3489;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import net.minecraft.class_7923;
import net.minecraft.world.item.*;
import net.minecraft.world.item.crafting.*;
import net.minecraft.world.level.block.*;

import java.util.*;

import static cc.cassian.lemonade.Lemonade.CONFIG;
import static de.crafty.eiv.common.recipe.inventory.SlotContent.getItemsFromTag;

public class LemonadeEIVPlugin implements IExtendedItemViewIntegration {


    @Override
    public void onIntegrationInitialize() {



        // register the server recipes
        ItemView.addRecipeProvider(recipeList -> {

            // Info Recipe - serverside
            recipeList.add(new InfoServerRecipe());

            if (CONFIG.lemonade.grindstone_workstation) {
                ServerRecipeManager.INSTANCE.getRecipesForType(LemonadeRecipes.GRINDING.get()).forEach(recipe -> {
                    recipeList.add(new WorldInteractionServerRecipe(recipe.getInput(), class_1856.method_8101(class_1802.field_16311), recipe.getResultItem()));
                });
            }


            // World Interaction Recipes
            var axes = class_1856.method_8106(getItemsFromTag(class_3489.field_42612).orElseThrow());
            var shovels = class_1856.method_8106(getItemsFromTag(class_3489.field_42615).orElseThrow());
            class_7923.field_41175.method_10220().forEach((block -> {
                if (block instanceof class_5955 weatheringCopper) {
                    Optional<class_2248> next = class_5955.method_34737(block);
                    next.ifPresent(value -> recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8101(block), class_1856.method_8101(class_1802.field_8557), value.method_8389().method_7854())));

                    Optional<class_2248> previous = class_5955.method_34732(block);
                    previous.ifPresent(value -> recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8101(block), axes, value.method_8389().method_7854())));
                }
                if (block instanceof class_2521 || block instanceof class_10594) {
                    recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8101(block), class_1856.method_8101(class_1802.field_8324), new class_1799(block, 2)));
                }
            }));
            class_5953.field_29560.get().forEach(((block, block2) -> {
                if (block != null && block2 != null)
                    recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8101(block), class_1856.method_8101(class_1802.field_20414), block2.method_8389().method_7854()));
            }));
            class_5953.field_29561.get().forEach(((block, block2) -> {
                if (block != null && block2 != null)
                    recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8101(block), axes, block2.method_8389().method_7854()));
            }));
            class_1821.field_8912.forEach(((block, state) -> {
                recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8101(block), shovels, state.method_26204().method_8389().method_7854()));
            }));
            class_1743.field_7898.forEach(((block, state) -> {
                recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8101(block), axes, state.method_8389().method_7854()));
            }));
            var hoes = class_1856.method_8106(getItemsFromTag(class_3489.field_42613).orElseThrow());
            recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8091(class_2246.field_10566, class_2246.field_10219, class_2246.field_10194), hoes, class_1802.field_8365.method_7854()));
            recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8101(class_2246.field_28685), hoes, class_1802.field_8831.method_7854()));
            recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8101(class_2246.field_28685), hoes, class_1802.field_28656.method_7854()));
            recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8091(class_2246.field_20422, class_2246.field_20421), class_1856.method_8101(class_1802.field_8868), new class_1799(class_1802.field_20414, 3)));
            recipeList.add(new WorldInteractionServerRecipe(class_1856.method_8091(class_2246.field_20422, class_2246.field_20421), class_1856.method_8101(class_1802.field_8469), class_1802.field_20417.method_7854()));
        });


        // Info Recipe - Clientside
        ItemView.registerRecipeWrapper(InfoServerRecipe.TYPE, modRecipe -> {
            ArrayList<InfoViewRecipe> infoRecipes = new ArrayList<>();
            if (ModCompat.ITEM_DESCRIPTIONS)
                ItemDescriptionsCompat.addItemDescriptionsInfoRecipes(infoRecipes);
            // add recipes here
            return infoRecipes;
        });

        ItemView.registerRecipeWrapper(WorldInteractionServerRecipe.TYPE, modRecipe -> {
            return Collections.singletonList(new WorldInteractionViewRecipe(modRecipe));
        });

    }

    public static void hideStacks() {
        List<class_1792> items = new ArrayList<>();
        getItemsFromTag(ConventionalItemTags.HIDDEN_FROM_RECIPE_VIEWERS).ifPresent((holders) -> holders.forEach((holder) -> items.add(holder.comp_349())));
        for (class_1792 item : items) {
            ItemView.excludeItem(item);
        }
    }


}
