package cc.cassian.lemonade.compat.eiv.info;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class InfoViewRecipe implements IEivViewRecipe {
    private final SlotContent output;
    private final String translationKey;

    public InfoViewRecipe(List<class_1799> output, String translationKey) {
        this.output = SlotContent.of(output);
        this.translationKey = translationKey;
    }

    public InfoViewRecipe(class_1799 output, String translationKey) {
        this.output = SlotContent.of(output);
        this.translationKey = translationKey;
    }

    public InfoViewRecipe(class_1792 output, String translationKey) {
        this.output = SlotContent.of(output);
        this.translationKey = translationKey;
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return InfoViewType.INSTANCE; //Here you need your type's instance you created before
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        //Tell EIV which SlotContent belongs to which of your previously defined slots
        slotFillContext.bindSlot(0, this.output);
    }

    @Override
    public void renderRecipe(RecipeViewScreen screen, RecipePosition recipePosition, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.method_51440(class_310.method_1551().field_1772, class_5348.method_29430(class_1074.method_4662(translationKey)), 5, 20, 112, -16777216, false);
    }

    @Override
    public List<SlotContent> getIngredients() {
        return List.of(); //Return all of your inputs here
    }

    @Override
    public List<SlotContent> getResults() {
        return List.of(this.output); //Return all of your outputs here
    }
}
