package cc.cassian.lemonade.compat.eiv.interaction;

import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;

import static cc.cassian.lemonade.Lemonade.MOD_ID;

public class WorldInteractionServerRecipe implements IEivServerRecipe {

    public static final EivRecipeType<WorldInteractionServerRecipe> TYPE = EivRecipeType.register(
            class_2960.method_60655(MOD_ID,"world_interaction"),
            () -> new WorldInteractionServerRecipe(null, null, null)
    );
    private class_1856 left;
    private class_1856 right;
    private class_1799 result;

    public WorldInteractionServerRecipe(class_1856 left, class_1856 right, class_1799 result) {
        this.left = left;
        this.right = right;
        this.result = result;
    }


    @Override
    public void writeToTag(class_2487 tag) {
        tag.method_10566("left", EivTagUtil.writeIngredient(left));
        tag.method_10566("right", EivTagUtil.writeIngredient(right));
        tag.method_10566("result", class_1799.field_24671.encodeStart(class_2509.field_11560, result).result().orElseThrow());
    }

    @Override
    public void loadFromTag(class_2487 tag) {
        left = EivTagUtil.readIngredient(tag.method_68568("left"));
        right = EivTagUtil.readIngredient(tag.method_68568("right"));
        result = class_1799.field_24671.decode(class_2509.field_11560, tag.method_10580("result")).result().get().getFirst();
    }

    @Override
    public EivRecipeType<? extends IEivServerRecipe> getRecipeType() {
        return TYPE;
    }

    public class_1856 getLeft() {
        return left;
    }

    public class_1856 getRight() {
        return right;
    }

    public class_1799 getResult() {
        return result;
    }
}
