package cc.cassian.lemonade.config;

import folk.sisby.kaleido.api.WrappedConfig;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Comment;

public class ModConfig extends WrappedConfig {

    public Lemonade lemonade = new Lemonade();
    public static class Lemonade implements folk.sisby.kaleido.api.WrappedConfig.Section {
        @Comment("Whether to register modded blocks and items that will prevent vanilla players from joining.")
        public boolean content = true;
        @Comment("Register custom cauldron interactions. These will not lock out vanilla players, but will not work as intended without both sides having the mod.")
        public boolean cauldronInteractions = true;
        @Comment("Register default component changes. These will not lock out vanilla players, but will not work as intended without both sides having the mod.")
        public boolean changeDefaultComponents = true;
        @Comment("Add particles to flying snowballs.")
        public boolean thrownItemParticles = true;
        @Comment("Allow the Grindstone to be used as a workstation for lemonade:grinding recipes.")
        public boolean grindstone_workstation = true;
        @Comment("Hide buttons to switch to the second page of Creative Tabs.")
        public boolean hideAdditionalPages = true;
        @Comment("Items in the flammable sticks item tag can be used to start fires.")
        public boolean sticks_start_fires = true;
        @Comment("Allow sticks to be placed")
        public boolean stickItems = true;
        @Comment("Misc changes specifically for Lemon Zest. Do not enable outside of the modpack.")
        public boolean lemon_zest = false;
    }

    public Datapacks contentPacks = new Datapacks();
    public static class Datapacks implements folk.sisby.kaleido.api.WrappedConfig.Section {
        @Comment("Serverside-only compatible changes to data and resources.")
        public boolean refreshment = true;
        @Comment("World generation changes designed for Lemon Zest.")
        public boolean worldgen = false;
        @Comment("Craftable enchanted books")
        public boolean tomes = true;
    }

    public EIV eiv = new EIV();
    public static class EIV implements folk.sisby.kaleido.api.WrappedConfig.Section {
        @Comment("Hide EIV's built-in mod name tooltips (best used for vanilla-only use cases or if you have another mod that shows this information)")
        public boolean hideNamespaces = true;
        @Comment("Add info recipes for spawn eggs - sourced from Item Descriptions.")
        public boolean spawnEggDescriptions = true;
        @Comment("Add info recipes for all items with Item Descriptions.")
        public boolean itemDescriptions = false;
    }

    public Jade jade = new Jade();
    public static class Jade implements folk.sisby.kaleido.api.WrappedConfig.Section {
        public boolean scoping = true;
    }

    public Vanilla vanilla = new Vanilla();
    public static class Vanilla implements folk.sisby.kaleido.api.WrappedConfig.Section {
        @Comment("Disable templates being consumed when used for smithing.")
        public boolean reusableTemplates = true;
        @Comment("Allow players to sleep through rain.")
        public boolean sleepThroughRain = true;
        @Comment("Allow Piglins to Zombify in the Overworld")
        public boolean piglinsZombify = false;
        @Comment("Allow Zombified Piglins to be cured.")
        public boolean piglinConversion = true;
        @Comment("Allow maps to be cleaned in Cauldrons.")
        public boolean clean_maps = true;
        @Comment("Allow campfires to be lit.")
        public boolean campfires_start_lit = false;
        @Comment("Increase the speed of Vanilla tools.")
        public boolean betterTools = true;
        @Comment("Allow Nether Portals to work")
        public boolean nether_portals = true;
        @Comment("Sneaking prevents damage when walking through a Sweet Berry Bush.")
        public boolean sneakingPreventsSweetBerryBushDamage = true;
        @Comment("Endermen can be bartered with.")
        public boolean enderTraders = true;
        @Comment("Blast Furnaces output 2 blocks.")
        public boolean betterBlasting = true;
        @Comment("Anvils no longer require experience.")
        public boolean freeAnvils = true;
        @Comment("Skeletons have half their usual health.")
        public boolean weakSkeletons = true;
        @Comment("Pumpkin and Melon Stems can be bone mealed to grow a full block.")
        public boolean growableStems = true;
        @Comment("Items can be repaired in the inventory with a single repair item.")
        public boolean cheapRepairs = true;
    }

    public FarmersDelight farmersDelight = new FarmersDelight();
    public static class FarmersDelight implements folk.sisby.kaleido.api.WrappedConfig.Section {
        @Comment("Allow Leads to place Rope blocks.")
        public boolean leadsAreRope = true;
        @Comment("Allow stoves to be lit.")
        public boolean stoves_start_lit = false;

    }

    public Gliders gliders = new Gliders();
    public static class Gliders implements folk.sisby.kaleido.api.WrappedConfig.Section {
        @Comment("Disable Lightning Strikes to Gliders.")
        public boolean disableLightning = true;
        @Comment("Disable Nether Damage to Gliders.")
        public boolean disableNetherDamage = true;
    }
}
