package cc.cassian.lemonade.mixin.eiv;

import cc.cassian.lemonade.Lemonade;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.moulberry.mixinconstraints.annotations.IfModLoaded;
import de.crafty.eiv.common.overlay.ItemSlot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;

@IfModLoaded(value = "eiv")
@Mixin(ItemSlot.class)
public class HideNamespaceMixin {
    @WrapOperation(
            method = "render",
            at = @At(value = "INVOKE", target = "Ljava/util/List;addLast(Ljava/lang/Object;)V")
    )
    private <E> void bypassExpensiveCalculationIfNecessary(List instance, E e, Operation<Void> original) {
        if (!Lemonade.CONFIG.eiv.hideNamespaces) original.call(instance, e);
    }
}
