package cc.cassian.lemonade.mixin.fabric;

import cc.cassian.lemonade.Lemonade;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.moulberry.mixinconstraints.annotations.IfModLoaded;
import net.fabricmc.fabric.impl.client.itemgroup.FabricCreativeGuiComponents;
import net.minecraft.class_481;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@IfModLoaded(value = "fabric-api")
@Mixin(FabricCreativeGuiComponents.ItemGroupButtonWidget.class)
public class HideCreativeTabsMixin {
    @WrapOperation(
            method = "renderWidget",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen;hasAdditionalPages()Z")
    )
    private boolean bypassExpensiveCalculationIfNecessary(class_481 instance, Operation<Boolean> original) {
        if (Lemonade.CONFIG.lemonade.hideAdditionalPages) {
            return false;
        } else {
            return original.call(instance);
        }
    }
}
