package cc.cassian.lemonade.mixin.farmersdelight;

import cc.cassian.lemonade.Lemonade;
import com.moulberry.mixinconstraints.annotations.IfModLoaded;
import net.minecraft.class_1750;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.block.StoveBlock;

@IfModLoaded(value = "farmersdelight")
@Mixin(StoveBlock.class)
public class UnlitStoveMixin {
    @Inject(
            method = "getStateForPlacement",
            at = @At(value = "RETURN"),
            cancellable = true)
    private void startCampfiresLit(class_1750 blockPlaceContext, CallbackInfoReturnable<class_2680> cir) {
        class_2680 state = cir.getReturnValue();
        if (!Lemonade.CONFIG.farmersDelight.stoves_start_lit && state != null)
            cir.setReturnValue(state.method_11657(StoveBlock.LIT, false));
    }
}
