package cc.cassian.lemonade.mixin.lemonade;

import cc.cassian.lemonade.core.LemonadePropertyModification;
import net.minecraft.class_2248;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2248.class)
public class BuffExplosionResistanceMixin {
    @Inject(method = "getExplosionResistance", at = @At("HEAD"), cancellable = true)
    private void overrideBlastResistance(CallbackInfoReturnable<Float> cir) {
        class_2248 self = (class_2248)(Object)this;
        String id = class_7923.field_41175.method_10221(self).toString();

        if (LemonadePropertyModification.hasCustomResistance(self, id)) {
            Float newResistance = LemonadePropertyModification.getExplosionResistance(self, id);
            cir.setReturnValue(newResistance);
        }
    }
}
