package cc.cassian.lemonade.mixin.lemonade;

import cc.cassian.lemonade.registry.LemonadeDataAttachments;
import cc.cassian.lemonade.registry.LemonadeTags;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(FabricItemGroupEntries.class)
public class HideEntriesMixin {
    @Inject(method = "accept", at = @At(value = "HEAD"), cancellable = true)
    private void mixin(class_1799 itemStack, class_1761.class_7705 tabVisibility, CallbackInfo ci) {
        if (itemStack.method_31573(LemonadeTags.DISABLED)) {
            ci.cancel();
        }
    }

    @Inject(method = "isEnabled", at = @At("RETURN"), cancellable = true)
    private void accept(class_1799 itemStack, CallbackInfoReturnable<Boolean> cir) {
        if (itemStack.method_31573(LemonadeTags.DISABLED)) {
            cir.setReturnValue(false);
        }
    }
}
