package cc.cassian.lemonade.mixin.lemonade;

import cc.cassian.lemonade.Lemonade;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1657.class)
public class SleepThroughRainMixin {
    // Allow sleeping in the rain.
    @WrapOperation(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;isBrightOutside()Z"))
    private boolean mixin(class_1937 level, Operation<Boolean> original) {
        var b = original.call(level);
        if (!b) return false;
        if (Lemonade.CONFIG.vanilla.sleepThroughRain && level.method_8419())
            return false;
        return true;
    }
}
