package cc.cassian.lemonade.recipe;

import cc.cassian.lemonade.registry.CommonRegistry;
import java.util.function.Supplier;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_3956;
import net.minecraft.class_9696;

import static cc.cassian.lemonade.Lemonade.MOD_ID;

public class LemonadeRecipes {

    public static final Supplier<class_3956<GrindstoneRecipe>> GRINDING = CommonRegistry.registerRecipe("grinding", () -> registerRecipeType("grinding"));

    public static final Supplier<class_1865<? extends class_1860<class_9696>>> GRINDING_SERIALIZER = CommonRegistry.registerRecipeSerializer("grinding", GrindstoneRecipe.Serializer::new);

    private static <T extends class_1860<?>> class_3956<T> registerRecipeType(final String identifier) {
        return new class_3956<>() {
            public String toString() {
                return MOD_ID + ":" + identifier;
            }
        };
    }

    public static void touch() {

    }
}