package cc.cassian.lemonade.registry;

import cc.cassian.lemonade.Lemonade;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_3414;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public class CommonRegistry {
    public static <R, T extends R> Supplier<T> register(String name, Supplier<T> supplier, class_2378<R> reg) {
        T object = supplier.get();
        class_2378.method_10230(reg, Lemonade.of(name), object);
        return () -> object;
    }

    public static <T> Supplier<class_9331<T>> registerComponentType(String name, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return register(name, () -> (builderOperator.apply(class_9331.method_57873())).method_57880(), class_7923.field_49658);
    }

    public static <B extends class_1792> Supplier<B> registerItem(String name, Supplier<B> supplier) {
        return register(name, supplier, class_7923.field_41178);
    }

    public static <B extends class_2248> Supplier<B> registerBlock(String name, Supplier<B> supplier) {
        return register(name, supplier, class_7923.field_41175);
    }

    public static <T extends class_1299<?>> Supplier<T> registerEntity(String name, Supplier<T> supplier) {
        return register(name, supplier, class_7923.field_41177);
    }

    public static Supplier<class_3414> registerSoundEvent(String name, Supplier<class_3414> supplier) {
        return register(name, supplier, class_7923.field_41172);
    }

    public static Supplier<class_3414> registerSoundEvent(String name) {
        return registerSoundEvent(name, ()->class_3414.method_47908(Lemonade.of(name)));
    }

    public static class_6880<class_1291> registerMobEffect(String name, Supplier<class_1291> supplier) {
        return class_2378.method_47985(class_7923.field_41174, Lemonade.of(name), supplier.get());
    }

    public static <B extends class_1865<?>> Supplier<B> registerRecipeSerializer(String name, Supplier<B> supplier) {
        return register(name, supplier, class_7923.field_41189);
    }

    public static <B extends class_3956<?>> Supplier<B> registerRecipe(String name, Supplier<B> supplier) {
        return register(name, supplier, class_7923.field_41188);
    }

}