package cc.cassian.lemonade.registry;

import cc.cassian.lemonade.Lemonade;
import cc.cassian.lemonade.blocks.StickBlock;
import cc.cassian.lemonade.config.ModConfig;
import net.minecraft.class_10594;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8805;
import net.minecraft.class_8812;
import net.minecraft.world.level.block.*;
import java.util.function.Function;
import java.util.function.Supplier;

public class LemonadeBlocks {

    public static final class_2248 WARPED_WART_BLOCK = register(
            "warped_wart_block", class_4970.class_2251.method_9637().method_31710(class_3620.field_25708).method_9632(1.0F).method_9626(class_2498.field_22144)
    );
    public static final class_2248 CRIMSON_WART_BLOCK = register(
            "crimson_wart_block", class_4970.class_2251.method_9637().method_31710(class_3620.field_16020).method_9632(1.0F).method_9626(class_2498.field_22144)
    );

    public static final class_2248 CLOVERS = register("clovers",
            class_10594::new, class_4970.class_2251.method_9630(class_2246.field_10503)
    );

    public static final class_2248 CHEERY_WILDFLOWERS = register("cheery_wildflowers",
            class_10594::new, class_4970.class_2251.method_9630(class_2246.field_42750)
    );

    public static final class_2248 MOODY_WILDFLOWERS = register("moody_wildflowers",
            class_10594::new, class_4970.class_2251.method_9630(class_2246.field_42750)
    );

    public static final class_2248 STICK = register("stick",
            StickBlock::new, class_4970.class_2251.method_9637(), Lemonade.CONFIG.lemonade.stickItems
    );

    private static class_2248 register(String id, Function<class_4970.class_2251, class_2248> function, class_4970.class_2251 properties, boolean shouldRegister) {
        if (shouldRegister) {
            return register(id, function, properties);
        } else {
            return null;
        }
    }

    public static final class_2248 BLACKSTONE_GRAVEL = register("blackstone_gravel",
            (properties)->new class_8812(new class_8805(0), properties), class_4970.class_2251.method_9637()
    );

    private static class_2248 register(class_5321<class_2248> resourceKey, Function<class_4970.class_2251, class_2248> function, class_4970.class_2251 properties) {
        // register block
        Supplier<class_2248> block = CommonRegistry.registerBlock(resourceKey.method_29177().method_12832(), ()-> function.apply(properties.method_63500(resourceKey)));
        // register item
        var itemKey = class_5321.method_29179(class_7924.field_41197, resourceKey.method_29177());
        CommonRegistry.registerItem(resourceKey.method_29177().method_12832(), ()-> new class_1747(block.get(), new class_1792.class_1793().method_63685().method_63686(itemKey)));
        // return
        return block.get();
    }

    private static class_5321<class_2248> registryKey(String string) {
        return class_5321.method_29179(class_7924.field_41254, Lemonade.of(string));
    }

    private static class_2248 register(String string, Function<class_4970.class_2251, class_2248> function, class_4970.class_2251 properties) {
        return register(registryKey(string), function, properties);
    }

    private static class_2248 register(String string, class_4970.class_2251 properties) {
        return register(string, class_2248::new, properties);
    }

    public static void touch() {

    }
}
