/*
 * Decompiled with CFR 0.152.
 */
package net.wolren.reach_display.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.wolren.reach_display.config.DisplayConfig;

public class SharedData {
    private static SharedData instance;
    private double localAverageDistance = 0.0;
    private int localAverageHitCount = 0;
    private final Queue<Double> lastHitsDistance = new LinkedList<Double>();
    private double averageDistance = 0.0;
    private static final String GLOBAL_AVERAGE_FILE_NAME = "global_average_hits.txt";
    private double distance;
    private class_1297 entity;
    private PrintWriter writer;

    private SharedData() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        File globalAverageFile = configDir.resolve(GLOBAL_AVERAGE_FILE_NAME).toFile();
        try {
            this.writer = new PrintWriter(new FileWriter(globalAverageFile, true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static SharedData getInstance() {
        if (instance == null) {
            instance = new SharedData();
        }
        return instance;
    }

    public void setDistanceAndTarget(double distance, class_1297 entity) {
        this.distance = distance;
        this.entity = entity;
    }

    public void addDistanceToAverage(double distance) {
        switch (DisplayConfig.averageHitMode) {
            case LOCAL_AVERAGE: {
                this.localAverageDistance += distance;
                ++this.localAverageHitCount;
                this.averageDistance = this.localAverageDistance / (double)this.localAverageHitCount;
                break;
            }
            case GLOBAL_AVERAGE: {
                this.writer.append(Double.toString(distance)).append(", ");
                this.writer.flush();
                Path configDir = FabricLoader.getInstance().getConfigDir();
                File globalAverageFile = configDir.resolve(GLOBAL_AVERAGE_FILE_NAME).toFile();
                try (BufferedReader reader = new BufferedReader(new FileReader(globalAverageFile));){
                    String line;
                    double sum = 0.0;
                    int count = 0;
                    while ((line = reader.readLine()) != null) {
                        String[] distances;
                        for (String distanceStr : distances = line.split(", ")) {
                            if (distanceStr.trim().isEmpty()) continue;
                            sum += Double.parseDouble(distanceStr);
                            ++count;
                        }
                    }
                    this.averageDistance = count > 0 ? sum / (double)count : 0.0;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case LAST_HITS: {
                this.lastHitsDistance.add(distance);
                if (this.lastHitsDistance.size() > DisplayConfig.averageNumberOfHitsCounted) {
                    this.lastHitsDistance.poll();
                }
                this.averageDistance = this.calculateAverageLastHitsDistance();
            }
        }
    }

    private double calculateAverageLastHitsDistance() {
        double sum = 0.0;
        Iterator iterator = this.lastHitsDistance.iterator();
        while (iterator.hasNext()) {
            double distance = (Double)iterator.next();
            sum += distance;
        }
        return sum / (double)this.lastHitsDistance.size();
    }

    public double getAverageDistance() {
        return this.averageDistance;
    }

    public double getDistance() {
        return this.distance;
    }

    public class_1297 getEntity() {
        return this.entity;
    }
}

