/*
 * Decompiled with CFR 0.152.
 */
package net.wolren.reach_display.mixin;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import net.wolren.reach_display.config.DisplayConfig;
import net.wolren.reach_display.data.SharedData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Shadow
    @Final
    private class_310 field_2035 = class_310.method_1551();

    @Shadow
    public abstract class_327 method_1756();

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void render(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        class_1297 entity;
        float scale;
        boolean shadow;
        int ARGBColorInt;
        float opacityScale;
        int colorInt;
        String colorHex;
        String displayString;
        class_1297 targetEntity;
        if (!DisplayConfig.enabled) {
            return;
        }
        class_746 player = this.field_2035.field_1724;
        class_239 target = this.field_2035.field_1765;
        if (player == null || target == null) {
            return;
        }
        if (target.method_17783() == class_239.class_240.field_1331 && DisplayConfig.distanceEnable && !(targetEntity = ((class_3966)target).method_17782()).method_5756((class_1657)player)) {
            if (DisplayConfig.showPlayers && !targetEntity.method_31747()) {
                return;
            }
            displayString = this.getDisplayString((class_1657)player, targetEntity);
            colorHex = DisplayConfig.distanceColor;
            colorInt = InGameHudMixin.parseColorWithDefault(colorHex);
            opacityScale = DisplayConfig.distanceOpacity;
            ARGBColorInt = InGameHudMixin.parseARGBColorWithOpacity(opacityScale, colorInt);
            shadow = DisplayConfig.distanceShadow;
            scale = DisplayConfig.distanceScale;
            this.renderText(context, displayString, this.getDistance((String)displayString).field_1343, this.getDistance((String)displayString).field_1342, ARGBColorInt, shadow, scale);
        }
        if (DisplayConfig.hitDistanceEnable && (entity = SharedData.getInstance().getEntity()) != null) {
            if (DisplayConfig.showPlayers && !entity.method_31747()) {
                return;
            }
            displayString = this.getHitDisplayString(SharedData.getInstance().getDistance());
            colorHex = DisplayConfig.hitDistanceColor;
            colorInt = InGameHudMixin.parseColorWithDefault(colorHex);
            opacityScale = DisplayConfig.hitDistanceOpacity;
            ARGBColorInt = InGameHudMixin.parseARGBColorWithOpacity(opacityScale, colorInt);
            shadow = DisplayConfig.hitDistanceShadow;
            scale = DisplayConfig.hitDistanceScale;
            this.renderText(context, displayString, this.getHitDistance((String)displayString).field_1343, this.getHitDistance((String)displayString).field_1342, ARGBColorInt, shadow, scale);
        }
        if (DisplayConfig.averageHitDistanceEnable && (entity = SharedData.getInstance().getEntity()) != null) {
            if (DisplayConfig.showPlayers && !entity.method_31747()) {
                return;
            }
            displayString = this.getAverageHitDisplayString(SharedData.getInstance().getAverageDistance());
            colorHex = DisplayConfig.averageHitDistanceColor;
            colorInt = InGameHudMixin.parseColorWithDefault(colorHex);
            opacityScale = DisplayConfig.averageHitDistanceOpacity;
            ARGBColorInt = InGameHudMixin.parseARGBColorWithOpacity(opacityScale, colorInt);
            shadow = DisplayConfig.averageHitDistanceShadow;
            scale = DisplayConfig.averageHitDistanceScale;
            this.renderText(context, displayString, this.getAverageHitDistance((String)displayString).field_1343, this.getAverageHitDistance((String)displayString).field_1342, ARGBColorInt, shadow, scale);
        }
    }

    @Unique
    private static int parseColorWithDefault(String colorHex) {
        if (colorHex.isEmpty()) {
            return 0xFFFFFF;
        }
        try {
            return (int)Long.parseLong(colorHex, 16);
        }
        catch (NumberFormatException e) {
            return 0xFFFFFF;
        }
    }

    @Unique
    private static int parseARGBColorWithOpacity(float opacityScale, int colorInt) {
        int alpha = (int)(opacityScale * 255.0f) & 0xFF;
        return alpha << 24 | colorInt & 0xFFFFFF;
    }

    @Unique
    private String getAverageHitDisplayString(Double distance) {
        int decimalPlaces = DisplayConfig.averageHitDistanceDecimalPlaces;
        DecimalFormat df = new DecimalFormat("0." + "0".repeat(decimalPlaces));
        return df.format(distance);
    }

    @Unique
    private String getHitDisplayString(Double distance) {
        int decimalPlaces = DisplayConfig.hitDistanceDecimalPlaces;
        DecimalFormat df = new DecimalFormat("0." + "0".repeat(decimalPlaces));
        return df.format(distance);
    }

    @Unique
    private String getDisplayString(class_1657 player, class_1297 targetEntity) {
        double maxReach;
        class_3966 entityHit;
        class_239 result = this.field_2035.field_1765;
        if (!(result instanceof class_3966) || (entityHit = (class_3966)result).method_17782() != targetEntity) {
            return "";
        }
        class_243 eyePos = player.method_33571();
        class_243 hitPos = entityHit.method_17784();
        double distance = eyePos.method_1022(hitPos);
        int decimalPlaces = DisplayConfig.distanceDecimalPlaces;
        DecimalFormat df = new DecimalFormat("0." + "0".repeat(decimalPlaces));
        df.setRoundingMode(RoundingMode.DOWN);
        double d = maxReach = player.method_68878() ? 5.0 : 3.0;
        if (player.method_7325()) {
            return "";
        }
        if (distance > maxReach) {
            return "";
        }
        return df.format(distance);
    }

    @Unique
    private void renderText(class_332 context, String text, float x, float y, int color, boolean shadow, float scale) {
        context.method_51448().scale(scale, scale);
        context.method_51433(this.method_1756(), text, (int)(x * (1.0f / scale)), (int)(y * (1.0f / scale)), color, shadow);
        context.method_51448().scale(1.0f / scale, 1.0f / scale);
    }

    @Unique
    public class_241 getDistance(String displayString) {
        float y = (float)this.field_2035.method_22683().method_4502() / 2.0f - (float)DisplayConfig.yOffset;
        float x = (float)this.field_2035.method_22683().method_4486() / 2.0f - (float)this.field_2035.field_1772.method_1727(displayString) / 2.0f * DisplayConfig.distanceScale - (float)DisplayConfig.xOffset;
        return new class_241(x, y);
    }

    @Unique
    public class_241 getHitDistance(String displayString) {
        float y = (float)this.field_2035.method_22683().method_4502() / 2.0f - (float)DisplayConfig.hitYOffset;
        float x = (float)this.field_2035.method_22683().method_4486() / 2.0f - (float)this.field_2035.field_1772.method_1727(displayString) / 2.0f * DisplayConfig.hitDistanceScale - (float)DisplayConfig.hitXOffset;
        return new class_241(x, y);
    }

    @Unique
    public class_241 getAverageHitDistance(String displayString) {
        float y = (float)this.field_2035.method_22683().method_4502() / 2.0f - (float)DisplayConfig.averageHitYOffset;
        float x = (float)this.field_2035.method_22683().method_4486() / 2.0f - (float)this.field_2035.field_1772.method_1727(displayString) / 2.0f * DisplayConfig.averageHitDistanceScale - (float)DisplayConfig.averageHitXOffset;
        return new class_241(x, y);
    }
}

