/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import it.crystalnest.prometheus.api.Fire;
import it.crystalnest.prometheus.api.FireManager;
import it.crystalnest.prometheus.api.block.CustomFireBlock;
import it.crystalnest.prometheus.api.type.FireTypeChanger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BaseFireBlock.class})
public abstract class BaseFireBlockCommonMixin
implements FireTypeChanger {
    @Unique
    private ResourceLocation fireType;

    @ModifyReturnValue(method={"getState"}, at={@At(value="RETURN")})
    private static BlockState modifyGetState(BlockState original, BlockGetter level, BlockPos pos) {
        return FireManager.getComponentList(Fire.Component.SOURCE_BLOCK).stream().filter(source -> BaseFireBlockCommonMixin.canSurvive(source, level.getBlockState(pos.below()))).findFirst().map(Block::defaultBlockState).orElse(original);
    }

    @Unique
    private static boolean canSurvive(Block source, BlockState base) {
        CustomFireBlock customFireBlock;
        return source instanceof CustomFireBlock && (customFireBlock = (CustomFireBlock)source).canSurvive(base);
    }

    @Override
    public ResourceLocation getFireType() {
        return this.fireType;
    }

    @Override
    public void setFireType(ResourceLocation fireType) {
        this.fireType = fireType;
    }
}

