/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.api.block;

import it.crystalnest.prometheus.api.Fire;
import it.crystalnest.prometheus.api.FireManager;
import it.crystalnest.prometheus.api.type.FireTyped;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;

public class CustomWallTorchBlock
extends WallTorchBlock
implements FireTyped {
    private final ResourceLocation fireType;
    private final Supplier<SimpleParticleType> type;

    public CustomWallTorchBlock(ResourceLocation fireType, Supplier<SimpleParticleType> type, BlockBehaviour.Properties properties) {
        this(fireType, type, true, properties);
    }

    public CustomWallTorchBlock(ResourceLocation fireType, Supplier<SimpleParticleType> type, boolean addDefaultProperties, BlockBehaviour.Properties properties) {
        super(null, (addDefaultProperties ? CustomWallTorchBlock.addDefaultProperties(properties) : properties).lightLevel(state -> FireManager.light(fireType)).overrideLootTable(CustomWallTorchBlock.getTorchBlock(fireType).getLootTable()).overrideDescription(CustomWallTorchBlock.getTorchBlock(fireType).getDescriptionId()));
        this.fireType = fireType;
        this.type = type;
    }

    private static BlockBehaviour.Properties addDefaultProperties(BlockBehaviour.Properties properties) {
        return properties.noCollission().instabreak().sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY);
    }

    public static Block getTorchBlock(ResourceLocation fireType) {
        return FireManager.getRequiredComponent(fireType, Fire.Component.TORCH_BLOCK);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (this.flameParticle == null) {
            this.flameParticle = this.type.get();
        }
        super.animateTick(state, level, pos, random);
    }

    @Override
    public ResourceLocation getFireType() {
        return this.fireType;
    }
}

