/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.crystalnest.prometheus.api.Fire;
import it.crystalnest.prometheus.api.FireManager;
import it.crystalnest.prometheus.api.type.FireTypeSynched;
import it.crystalnest.prometheus.api.type.FireTyped;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements FireTypeSynched {
    @Unique
    private static final EntityDataAccessor<String> DATA_FIRE_TYPE = SynchedEntityData.defineId(Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    @Final
    @Shadow
    protected SynchedEntityData entityData;
    @Shadow
    private Level level;

    @Shadow
    public abstract int getRemainingFireTicks();

    @Shadow
    public abstract boolean fireImmune();

    @Override
    public ResourceLocation getFireType() {
        return ResourceLocation.tryParse((String)((String)this.entityData.get(DATA_FIRE_TYPE)));
    }

    @Override
    public void setFireType(ResourceLocation fireType) {
        if (!this.fireImmune()) {
            this.entityData.set(DATA_FIRE_TYPE, (Object)FireManager.ensure(fireType).toString());
        }
    }

    @Override
    public EntityDataAccessor<String> fireTypeAccessor() {
        return DATA_FIRE_TYPE;
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean wrapHurtServer(Entity instance, ServerLevel level, DamageSource damageSource, float damage, Operation<Boolean> original) {
        return FireManager.affect(instance, ((FireTyped)instance).getFireType(), Fire::getOnFire, (xva$0, xva$1, xva$2, xva$3) -> (Boolean)original.call(new Object[]{xva$0, xva$1, xva$2, xva$3}));
    }

    @WrapOperation(method={"lavaIgnite"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;igniteForSeconds(F)V")})
    private void wrapIgniteForSeconds(Entity instance, float seconds, Operation<Void> original) {
        FireManager.setOnFire(instance, seconds, FireManager.DEFAULT_FIRE_TYPE, (xva$0, xva$1) -> {
            Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0, xva$1});
        });
    }

    @Inject(method={"setRemainingFireTicks"}, at={@At(value="HEAD")})
    private void onSetRemainingFireTicks(int ticks, CallbackInfo ci) {
        if (!this.level.isClientSide && ticks >= this.getRemainingFireTicks()) {
            this.setFireType(FireManager.DEFAULT_FIRE_TYPE);
        }
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V")})
    private void onSaveWithoutId(ValueOutput output, CallbackInfo ci) {
        FireManager.writeTag(output, this.getFireType());
    }

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V")})
    private void onLoad(ValueInput input, CallbackInfo ci) {
        this.setFireType(FireManager.readTag(input));
    }
}

