/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.api;

import it.crystalnest.cobweb.api.block.entity.DynamicBlockEntityType;
import it.crystalnest.cobweb.api.pack.dynamic.DynamicDataPack;
import it.crystalnest.cobweb.api.pack.dynamic.DynamicTagBuilder;
import it.crystalnest.cobweb.api.registry.CobwebEntry;
import it.crystalnest.cobweb.api.registry.CobwebRegister;
import it.crystalnest.cobweb.api.registry.CobwebRegistry;
import it.crystalnest.prometheus.Constants;
import it.crystalnest.prometheus.api.Fire;
import it.crystalnest.prometheus.api.block.CustomCampfireBlock;
import it.crystalnest.prometheus.api.block.CustomFireBlock;
import it.crystalnest.prometheus.api.block.CustomLanternBlock;
import it.crystalnest.prometheus.api.block.CustomTorchBlock;
import it.crystalnest.prometheus.api.block.CustomWallTorchBlock;
import it.crystalnest.prometheus.api.block.entity.CustomCampfireBlockEntity;
import it.crystalnest.prometheus.api.type.FireTypeChanger;
import it.crystalnest.prometheus.api.type.FireTyped;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FireManager {
    public static final ResourceLocation DEFAULT_FIRE_TYPE = ResourceLocation.withDefaultNamespace((String)"");
    public static final Fire DEFAULT_FIRE = new Fire(DEFAULT_FIRE_TYPE, 15, 1.0f, false, true, Fire.Builder.DEFAULT_ON_CAMPFIRE_GETTER, Fire.Builder.DEFAULT_IN_FIRE_GETTER, Fire.Builder.DEFAULT_ON_FIRE_GETTER, Fire.Builder.DEFAULT_BEHAVIOR, Map.ofEntries(Map.entry(Fire.Component.SOURCE_BLOCK, BuiltInRegistries.BLOCK.getKey((Object)Blocks.FIRE)), Map.entry(Fire.Component.CAMPFIRE_BLOCK, BuiltInRegistries.BLOCK.getKey((Object)Blocks.CAMPFIRE)), Map.entry(Fire.Component.LANTERN_BLOCK, BuiltInRegistries.BLOCK.getKey((Object)Blocks.LANTERN)), Map.entry(Fire.Component.TORCH_BLOCK, BuiltInRegistries.BLOCK.getKey((Object)Blocks.TORCH)), Map.entry(Fire.Component.WALL_TORCH_BLOCK, BuiltInRegistries.BLOCK.getKey((Object)Blocks.WALL_TORCH)), Map.entry(Fire.Component.FLAME_PARTICLE, BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.FLAME))));
    public static final CobwebEntry<DynamicBlockEntityType<CustomCampfireBlockEntity>> CUSTOM_CAMPFIRE_ENTITY_TYPE = CobwebRegistry.of((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"prometheus").register("custom_campfire", () -> DynamicBlockEntityType.of(CustomCampfireBlockEntity::new, state -> FireManager.getComponentList(Fire.Component.CAMPFIRE_BLOCK).stream().filter(CustomCampfireBlock.class::isInstance).toList().contains(state.getBlock())));
    private static final DynamicDataPack FIRE_SOURCE_TAGS = DynamicDataPack.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"prometheus", (String)"fire_source_tags"));
    private static final DynamicDataPack CAMPFIRE_TAGS = DynamicDataPack.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"prometheus", (String)"campfire_tags"));
    private static final ConcurrentHashMap<ResourceLocation, Fire> FIRES = new ConcurrentHashMap();
    private static boolean LOADED = false;

    @ApiStatus.Internal
    public static synchronized void load() {
        if (LOADED) {
            throw new IllegalStateException("FireManager was already loaded");
        }
        LOADED = true;
    }

    private FireManager() {
    }

    public static Fire.Builder fireBuilder(String modId, String fireId) {
        return new Fire.Builder(modId, fireId);
    }

    public static Fire.Builder fireBuilder(ResourceLocation fireType) {
        return new Fire.Builder(fireType);
    }

    @Nullable
    public static synchronized Fire registerFire(Fire fire) {
        Fire previous = FIRES.computeIfAbsent(fire.getFireType(), key -> {
            Fire.Component.SOURCE_BLOCK.getOptionalValue(fire).ifPresent(FireManager.setTypeOrWarn(key));
            Fire.Component.CAMPFIRE_BLOCK.getOptionalValue(fire).ifPresent(FireManager.setTypeOrWarn(key));
            return fire;
        });
        if (previous != fire) {
            ResourceLocation fireType = fire.getFireType();
            Constants.LOGGER.error("Fire [{}] was already registered with the following value: {}", (Object)fireType, (Object)FireManager.getFire(fireType));
            return null;
        }
        Constants.LOGGER.debug("Successfully registered Fire [{}]", (Object)fire);
        return fire;
    }

    @NotNull
    private static Consumer<Block> setTypeOrWarn(ResourceLocation fireType) {
        return block -> {
            if (block instanceof FireTypeChanger) {
                FireTypeChanger fireTypeChanger = (FireTypeChanger)block;
                fireTypeChanger.setFireType(fireType);
            } else {
                Constants.LOGGER.warn("Could not set Fire Type [{}] for block [{}]\nThings might not work as expected!\nYou can ignore this warning if this was intended", (Object)fireType, block);
            }
        };
    }

    public static synchronized Map<ResourceLocation, @Nullable Fire> registerFires(Fire ... fires) {
        return FireManager.registerFires(List.of(fires));
    }

    public static synchronized Map<ResourceLocation, @Nullable Fire> registerFires(List<Fire> fires) {
        HashMap<ResourceLocation, @Nullable Fire> outcomes = new HashMap<ResourceLocation, Fire>();
        for (Fire fire : fires) {
            outcomes.put(fire.getFireType(), FireManager.registerFire(fire));
        }
        return outcomes;
    }

    @Nullable
    @ApiStatus.Internal
    public static synchronized Fire unregisterFire(ResourceLocation fireType) {
        return FIRES.remove(fireType);
    }

    public static <T extends CustomFireBlock> CobwebEntry<T> registerFireSource(ResourceLocation fireType, MapColor color, BiFunction<ResourceLocation, BlockBehaviour.Properties, T> constructor) {
        CobwebEntry source = CobwebRegistry.ofBlocks((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.SOURCE_BLOCK), () -> (CustomFireBlock)constructor.apply(fireType, BlockBehaviour.Properties.of().mapColor(color)));
        FIRE_SOURCE_TAGS.add(new Supplier[]{() -> DynamicTagBuilder.of((ResourceKey)Registries.BLOCK, (TagKey[])new TagKey[]{BlockTags.FIRE}).addElement((Object)((Block)source.get()))});
        return source;
    }

    public static <T extends CustomFireBlock> CobwebEntry<T> registerFireSource(ResourceLocation fireType, TagKey<Block> base, MapColor color, TriFunction<ResourceLocation, TagKey<Block>, BlockBehaviour.Properties, T> constructor) {
        return FireManager.registerFireSource(fireType, color, (type, properties) -> (CustomFireBlock)constructor.apply(type, (Object)base, properties));
    }

    public static <T extends CustomCampfireBlock> CobwebEntry<T> registerCampfire(ResourceLocation fireType, BiFunction<ResourceLocation, BlockBehaviour.Properties, T> constructor) {
        CobwebEntry campfire = CobwebRegistry.ofBlocks((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.CAMPFIRE_BLOCK), () -> (CustomCampfireBlock)constructor.apply(fireType, BlockBehaviour.Properties.of()));
        FIRE_SOURCE_TAGS.add(new Supplier[]{() -> DynamicTagBuilder.of((ResourceKey)Registries.BLOCK, (TagKey[])new TagKey[]{BlockTags.CAMPFIRES}).addElement((Object)((Block)campfire.get()))});
        return campfire;
    }

    public static <T extends CustomCampfireBlock> CobwebEntry<T> registerCampfire(ResourceLocation fireType, boolean spawnParticles, TriFunction<ResourceLocation, Boolean, BlockBehaviour.Properties, T> constructor) {
        return FireManager.registerCampfire(fireType, (type, properties) -> (CustomCampfireBlock)constructor.apply(type, (Object)spawnParticles, properties));
    }

    public static CobwebEntry<BlockItem> registerCampfireItem(ResourceLocation fireType) {
        return FireManager.registerCampfireItem(fireType, BlockItem::new);
    }

    public static <T extends BlockItem> CobwebEntry<T> registerCampfireItem(ResourceLocation fireType, BiFunction<Block, Item.Properties, T> supplier) {
        return CobwebRegistry.ofItems((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.CAMPFIRE_ITEM), () -> (BlockItem)supplier.apply(FireManager.getRequiredComponent(fireType, Fire.Component.CAMPFIRE_BLOCK), new Item.Properties()));
    }

    public static CobwebEntry<SimpleParticleType> registerParticle(ResourceLocation fireType) {
        return FireManager.registerParticle(fireType, () -> new SimpleParticleType(false));
    }

    public static <T extends SimpleParticleType> CobwebEntry<T> registerParticle(ResourceLocation fireType, Supplier<T> supplier) {
        return CobwebRegistry.of((ResourceKey)Registries.PARTICLE_TYPE, (String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.FLAME_PARTICLE), supplier);
    }

    public static Pair<CobwebEntry<CustomTorchBlock>, CobwebEntry<CustomWallTorchBlock>> registerTorch(ResourceLocation fireType) {
        return FireManager.registerTorch(fireType, CustomTorchBlock::new, CustomWallTorchBlock::new);
    }

    public static <T extends CustomTorchBlock, W extends CustomWallTorchBlock> Pair<CobwebEntry<T>, CobwebEntry<W>> registerTorch(ResourceLocation fireType, TriFunction<ResourceLocation, Supplier<SimpleParticleType>, BlockBehaviour.Properties, T> torchSupplier, TriFunction<ResourceLocation, Supplier<SimpleParticleType>, BlockBehaviour.Properties, W> wallTorchSupplier) {
        CobwebRegister blocks = CobwebRegistry.ofBlocks((String)FireManager.fireMod(fireType));
        return Pair.of((Object)blocks.register(FireManager.getComponentPath(fireType, Fire.Component.TORCH_BLOCK), () -> (CustomTorchBlock)torchSupplier.apply((Object)fireType, () -> FireManager.getRequiredComponent(fireType, Fire.Component.FLAME_PARTICLE), (Object)BlockBehaviour.Properties.of())), (Object)blocks.register(FireManager.getComponentPath(fireType, Fire.Component.WALL_TORCH_BLOCK), () -> (CustomWallTorchBlock)wallTorchSupplier.apply((Object)fireType, () -> FireManager.getRequiredComponent(fireType, Fire.Component.FLAME_PARTICLE), (Object)BlockBehaviour.Properties.of())));
    }

    public static <T extends StandingAndWallBlockItem> CobwebEntry<T> registerTorchItem(ResourceLocation fireType, BiFunction<Block, Block, T> supplier) {
        return CobwebRegistry.ofItems((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.TORCH_ITEM), () -> (StandingAndWallBlockItem)supplier.apply(FireManager.getRequiredComponent(fireType, Fire.Component.TORCH_BLOCK), FireManager.getRequiredComponent(fireType, Fire.Component.WALL_TORCH_BLOCK)));
    }

    public static CobwebEntry<StandingAndWallBlockItem> registerTorchItem(ResourceLocation fireType) {
        return FireManager.registerTorchItem(fireType, (torch, wallTorch, properties) -> new StandingAndWallBlockItem(torch, wallTorch, properties, Direction.DOWN));
    }

    public static <T extends StandingAndWallBlockItem> CobwebEntry<T> registerTorchItem(ResourceLocation fireType, TriFunction<Block, Block, Item.Properties, T> constructor) {
        return FireManager.registerTorchItem(fireType, constructor, new Item.Properties());
    }

    public static <T extends StandingAndWallBlockItem> CobwebEntry<T> registerTorchItem(ResourceLocation fireType, TriFunction<Block, Block, Item.Properties, T> constructor, Item.Properties properties) {
        return CobwebRegistry.ofItems((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.TORCH_ITEM), () -> (StandingAndWallBlockItem)constructor.apply((Object)FireManager.getRequiredComponent(fireType, Fire.Component.TORCH_BLOCK), (Object)FireManager.getRequiredComponent(fireType, Fire.Component.WALL_TORCH_BLOCK), (Object)properties));
    }

    public static CobwebEntry<CustomLanternBlock> registerLantern(ResourceLocation fireType) {
        return FireManager.registerLantern(fireType, CustomLanternBlock::new);
    }

    public static <T extends CustomLanternBlock> CobwebEntry<T> registerLantern(ResourceLocation fireType, BiFunction<ResourceLocation, BlockBehaviour.Properties, T> supplier) {
        return CobwebRegistry.ofBlocks((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.LANTERN_BLOCK), () -> (CustomLanternBlock)supplier.apply(fireType, BlockBehaviour.Properties.of()));
    }

    public static CobwebEntry<BlockItem> registerLanternItem(ResourceLocation fireType) {
        return FireManager.registerLanternItem(fireType, BlockItem::new);
    }

    public static <T extends BlockItem> CobwebEntry<T> registerLanternItem(ResourceLocation fireType, BiFunction<Block, Item.Properties, T> constructor) {
        return FireManager.registerLanternItem(fireType, constructor, new Item.Properties());
    }

    public static <T extends BlockItem> CobwebEntry<T> registerLanternItem(ResourceLocation fireType, BiFunction<Block, Item.Properties, T> constructor, Item.Properties properties) {
        return CobwebRegistry.ofItems((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.LANTERN_ITEM), () -> (BlockItem)constructor.apply(FireManager.getRequiredComponent(fireType, Fire.Component.LANTERN_BLOCK), properties));
    }

    public static Fire getFire(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId) ? FireManager.getFire(FireManager.fireType(modId, fireId)) : DEFAULT_FIRE;
    }

    public static Fire getFire(@Nullable ResourceLocation fireType) {
        return FIRES.getOrDefault(FireManager.ensure(fireType), DEFAULT_FIRE);
    }

    public static List<Fire> getFires() {
        return FIRES.values().stream().toList();
    }

    public static <T> T getProperty(ResourceLocation fireType, Function<Fire, T> getter) {
        return getter.apply(FireManager.getFire(fireType));
    }

    public static DamageSource getDamageSource(Entity entity, ResourceLocation fireType, BiFunction<Fire, Entity, DamageSource> getter) {
        return getter.apply(FireManager.getFire(fireType), entity);
    }

    @Nullable
    public static ResourceLocation getComponentId(ResourceLocation fireType, Fire.Component<?, ?> component) {
        return FireManager.getFire(fireType).getComponent(component);
    }

    @Nullable
    public static <R, T extends R> T getComponent(ResourceLocation fireType, Fire.Component<R, T> component) {
        return component.getValue(FireManager.getComponentId(fireType, component));
    }

    @NotNull
    private static String getComponentPath(ResourceLocation fireType, Fire.Component<?, ?> component) {
        return Objects.requireNonNull(FireManager.getComponentId(fireType, component)).getPath();
    }

    @NotNull
    public static <R, T extends R> T getRequiredComponent(ResourceLocation fireType, Fire.Component<R, T> component) throws NullPointerException {
        return Objects.requireNonNull(component.getValue(FireManager.getComponentId(fireType, component)));
    }

    public static <T> List<T> getPropertyList(Function<Fire, T> getter) {
        return FIRES.values().stream().map(getter).toList();
    }

    public static List<ResourceLocation> getComponentIdList(Fire.Component<?, ?> component) {
        return FIRES.values().stream().map(fire -> fire.getComponent(component)).filter(Objects::nonNull).toList();
    }

    public static <R, T extends R> List<T> getComponentList(Fire.Component<R, T> component) {
        return FIRES.values().stream().map(component::getValue).filter(Objects::nonNull).toList();
    }

    public static boolean isValidType(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId);
    }

    public static boolean isValidType(@Nullable ResourceLocation fireType) {
        return fireType != null && Strings.isNotBlank((String)FireManager.fireMod(fireType)) && Strings.isNotBlank((String)fireType.getPath());
    }

    public static boolean isRegisteredType(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId) && FireManager.isRegisteredType(FireManager.fireType(modId, fireId));
    }

    public static boolean isRegisteredType(@Nullable ResourceLocation fireType) {
        return fireType != null && FIRES.containsKey(fireType);
    }

    public static boolean isValidFireId(@Nullable String fireId) {
        return Strings.isNotBlank((String)fireId) && ResourceLocation.isValidPath((String)fireId);
    }

    public static boolean isRegisteredFireId(@Nullable String fireId) {
        return FireManager.isValidFireId(fireId) && FIRES.keySet().stream().anyMatch(fireType -> fireType.getPath().equals(fireId));
    }

    public static boolean isValidModId(@Nullable String modId) {
        return Strings.isNotBlank((String)modId) && ResourceLocation.isValidNamespace((String)modId);
    }

    public static boolean isRegisteredModId(@Nullable String modId) {
        return FireManager.isValidModId(modId) && FIRES.keySet().stream().anyMatch(fireType -> FireManager.fireMod(fireType).equals(modId));
    }

    public static ResourceLocation sanitize(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidModId(fireId) ? FireManager.sanitize(FireManager.fireType(modId, fireId)) : DEFAULT_FIRE_TYPE;
    }

    public static ResourceLocation sanitize(@Nullable ResourceLocation fireType) {
        return FireManager.isValidType(fireType) ? fireType : DEFAULT_FIRE_TYPE;
    }

    public static ResourceLocation ensure(@Nullable String modId, @Nullable String fireId) {
        String trimmedModId = modId == null ? "" : modId.trim();
        String trimmedFireId = fireId == null ? "" : fireId.trim();
        return FireManager.isValidModId(trimmedModId) && FireManager.isValidFireId(trimmedFireId) ? FireManager.ensure(ResourceLocation.fromNamespaceAndPath((String)trimmedModId, (String)trimmedFireId)) : DEFAULT_FIRE_TYPE;
    }

    public static ResourceLocation ensure(@Nullable ResourceLocation fireType) {
        return FireManager.isRegisteredType(fireType) ? fireType : DEFAULT_FIRE_TYPE;
    }

    public static List<ResourceLocation> getFireTypes() {
        return FIRES.keySet().stream().toList();
    }

    public static List<String> getFireIds() {
        return FIRES.keySet().stream().map(ResourceLocation::getPath).toList();
    }

    public static List<String> getModIds() {
        return FIRES.keySet().stream().map(ResourceLocation::getNamespace).toList();
    }

    public static void setOnFire(Entity entity, float seconds, ResourceLocation fireType) {
        FireManager.setOnFire(entity, seconds, fireType, Entity::igniteForSeconds);
    }

    @ApiStatus.Internal
    public static void setOnFire(Entity entity, float seconds, ResourceLocation fireType, BiConsumer<Entity, Float> setOnFireFunction) {
        setOnFireFunction.accept(entity, Float.valueOf(seconds));
        ((FireTypeChanger)entity).setFireType(FireManager.ensure(fireType));
    }

    public static boolean affect(Entity entity, ResourceLocation fireType, BiFunction<Fire, Entity, DamageSource> damageSourceGetter) {
        return FireManager.affect(entity, fireType, damageSourceGetter, (TriFunction<Entity, DamageSource, Float, Boolean>)((TriFunction)Entity::hurt));
    }

    @ApiStatus.Internal
    public static boolean affect(Entity entity, ResourceLocation fireType, BiFunction<Fire, Entity, DamageSource> damageSourceGetter, TriFunction<Entity, DamageSource, Float, Boolean> hurtFunction) {
        ((FireTypeChanger)entity).setFireType(FireManager.ensure(fireType));
        return FireManager.affect(entity, FireManager.getDamageSource(entity, fireType, damageSourceGetter), FireManager.getProperty(fireType, Fire::getDamage).floatValue(), FireManager.getProperty(fireType, Fire::invertHealAndHarm), hurtFunction);
    }

    private static boolean affect(Entity entity, DamageSource damageSource, float damage, boolean invertHealAndHarm, TriFunction<Entity, DamageSource, Float, Boolean> hurtFunction) {
        Predicate behavior = FireManager.getProperty(((FireTyped)entity).getFireType(), Fire::getBehavior);
        if (behavior.test(entity) && Float.compare(damage, 0.0f) != 0) {
            if (damage > 0.0f) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (livingEntity.isInvertedHealAndHarm() && invertHealAndHarm) {
                        livingEntity.heal(damage);
                        return false;
                    }
                    return (Boolean)hurtFunction.apply((Object)livingEntity, (Object)damageSource, (Object)Float.valueOf(damage));
                }
                return (Boolean)hurtFunction.apply((Object)entity, (Object)damageSource, (Object)Float.valueOf(damage));
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.isInvertedHealAndHarm() && invertHealAndHarm) {
                    return (Boolean)hurtFunction.apply((Object)livingEntity, (Object)damageSource, (Object)Float.valueOf(-damage));
                }
                livingEntity.heal(-damage);
                return false;
            }
        }
        return false;
    }

    private static ResourceLocation fireType(@Nullable String modId, @Nullable String fireId) {
        return ResourceLocation.fromNamespaceAndPath((String)Objects.requireNonNull(modId), (String)Objects.requireNonNull(fireId));
    }

    private static String fireMod(ResourceLocation fireType) {
        return fireType.getNamespace();
    }

    public static int light(ResourceLocation fireType) {
        return FireManager.getProperty(fireType, Fire::getLight);
    }

    static {
        FIRE_SOURCE_TAGS.register();
        CAMPFIRE_TAGS.register();
    }
}

