/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.handler;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.crystalnest.prometheus.Constants;
import it.crystalnest.prometheus.api.Fire;
import it.crystalnest.prometheus.api.FireManager;
import it.crystalnest.prometheus.platform.Services;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireResourceReloadListener
extends SimpleJsonResourceReloadListener {
    private static final ArrayList<ResourceLocation> ddfiresUnregister = new ArrayList();
    private static final ArrayList<ResourceLocation> ddfiresRegister = new ArrayList();
    private static final String SOURCE_FIELD_NAME = "source";
    private static final String CAMPFIRE_FIELD_NAME = "campfire";

    public FireResourceReloadListener() {
        super(new Gson(), "fires");
    }

    public static void handle(@Nullable ServerPlayer player) {
        for (ResourceLocation fireType : ddfiresUnregister) {
            Services.NETWORK.sendToClient(player, fireType);
        }
        for (ResourceLocation fireType : ddfiresRegister) {
            Services.NETWORK.sendToClient(player, FireManager.getFire(fireType));
        }
    }

    private static JsonObject getJsonObject(String identifier, JsonElement element) throws IllegalStateException {
        try {
            return element.getAsJsonObject();
        }
        catch (IllegalStateException e) {
            Constants.LOGGER.error("prometheus encountered a non-blocking DDFire error!\nError parsing ddfire [{}]: not a JSON object.", (Object)identifier);
            throw e;
        }
    }

    private static <T> T parse(String identifier, String field, JsonObject data, Function<JsonElement, T> parser) throws NullPointerException, UnsupportedOperationException, IllegalStateException, NumberFormatException {
        try {
            return parser.apply(data.get(field));
        }
        catch (IllegalStateException | NullPointerException | NumberFormatException | UnsupportedOperationException e) {
            Constants.LOGGER.error("prometheus encountered a non-blocking DDFire error!\nError parsing required field \"{}\" for ddfire [{}]: missing or malformed field.", (Object)field, (Object)identifier);
            throw e;
        }
    }

    private static <T> T parse(String identifier, String field, JsonObject data, Function<JsonElement, T> parser, T fallback) throws UnsupportedOperationException, IllegalStateException, NumberFormatException {
        try {
            return parser.apply(data.get(field));
        }
        catch (NullPointerException e) {
            return fallback;
        }
        catch (IllegalStateException | NumberFormatException | UnsupportedOperationException e) {
            Constants.LOGGER.error("prometheus encountered a non-blocking DDFire error!\nError parsing optional field \"{}\" for ddfire [{}]: malformed field.", (Object)field, (Object)identifier);
            throw e;
        }
    }

    private static void unregisterFires() {
        for (ResourceLocation fireType : ddfiresRegister) {
            if (FireManager.unregisterFire(fireType) == null) continue;
            ddfiresUnregister.add(fireType);
        }
        ddfiresRegister.clear();
    }

    private static void registerFire(ResourceLocation fireType, Fire fire) {
        if (FireManager.registerFire(fire) != null) {
            ddfiresRegister.add(fireType);
        } else {
            Constants.LOGGER.error("Unable to register ddfire [{}].", (Object)fireType);
        }
    }

    private static void registerFire(JsonObject jsonFire, String mod, String jsonIdentifier) {
        ResourceLocation fireType = ResourceLocation.fromNamespaceAndPath((String)mod, (String)FireResourceReloadListener.parse(jsonIdentifier, "fire", jsonFire, JsonElement::getAsString));
        String fireTypeString = fireType.toString();
        Fire.Builder builder = FireManager.fireBuilder(fireType).setDamage(FireResourceReloadListener.parse(fireTypeString, "damage", jsonFire, JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue()).setInvertHealAndHarm(FireResourceReloadListener.parse(fireTypeString, "invertHealAndHarm", jsonFire, JsonElement::getAsBoolean, false)).removeComponents(Fire.Component.CAMPFIRE_ITEM, Fire.Component.LANTERN_BLOCK, Fire.Component.LANTERN_ITEM, Fire.Component.TORCH_BLOCK, Fire.Component.TORCH_ITEM, Fire.Component.WALL_TORCH_BLOCK, Fire.Component.FLAME_PARTICLE);
        FireResourceReloadListener.removeOrSet(fireTypeString, builder, jsonFire, SOURCE_FIELD_NAME, Fire.Component.SOURCE_BLOCK);
        FireResourceReloadListener.removeOrSet(fireTypeString, builder, jsonFire, CAMPFIRE_FIELD_NAME, Fire.Component.CAMPFIRE_BLOCK);
        FireResourceReloadListener.registerFire(fireType, builder.build());
    }

    private static void removeOrSet(String fireType, Fire.Builder builder, JsonObject data, String field, Fire.Component<?, ?> component) {
        if (data.get(field) != null && data.get(field).getAsString().equals("remove")) {
            builder.removeComponent(component);
        } else {
            String value = FireResourceReloadListener.parse(fireType, field, data, JsonElement::getAsString, null);
            if (value != null && ResourceLocation.tryParse((String)value) != null) {
                builder.setComponent(component, ResourceLocation.parse((String)value));
            }
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> fires, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        FireResourceReloadListener.unregisterFires();
        for (Map.Entry<ResourceLocation, JsonElement> fire : fires.entrySet()) {
            String jsonIdentifier = fire.getKey().getPath();
            try {
                JsonObject jsonData = FireResourceReloadListener.getJsonObject(jsonIdentifier, fire.getValue());
                String mod = FireResourceReloadListener.parse(jsonIdentifier, "mod", jsonData, JsonElement::getAsString);
                if (Services.PLATFORM.isModLoaded(mod)) {
                    FireResourceReloadListener.parse(jsonIdentifier, "fires", jsonData, JsonElement::getAsJsonArray).forEach(element -> FireResourceReloadListener.registerFire(FireResourceReloadListener.getJsonObject(jsonIdentifier, element), mod, jsonIdentifier));
                    continue;
                }
                Constants.LOGGER.warn("Registering of ddfires for [{}] is canceled: {} is not loaded.", (Object)mod, (Object)mod);
            }
            catch (IllegalStateException | NullPointerException | NumberFormatException | UnsupportedOperationException e) {
                Constants.LOGGER.error("Registering of ddfires for [{}] is canceled.", (Object)jsonIdentifier);
            }
        }
    }
}

