/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.api;

import com.google.common.collect.ImmutableMap;
import it.crystalnest.prometheus.api.FireManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1827;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Fire {
    public static final class_9139<class_2540, Fire> STREAM_CODEC = new class_9139<class_2540, Fire>(){

        public void encode(class_2540 buffer, Fire fire) {
            class_2960 campfire;
            buffer.method_10812(fire.getFireType());
            buffer.method_52941(fire.getDamage());
            buffer.method_52964(fire.invertHealAndHarm());
            @Nullable class_2960 source = fire.getComponent(Component.SOURCE_BLOCK);
            buffer.method_52964(source != null);
            if (source != null) {
                buffer.method_10812(source);
            }
            buffer.method_52964((campfire = fire.getComponent(Component.CAMPFIRE_BLOCK)) != null);
            if (campfire != null) {
                buffer.method_10812(campfire);
            }
        }

        @NotNull
        public Fire decode(class_2540 buffer) {
            Builder builder = FireManager.fireBuilder(buffer.method_10810()).setDamage(buffer.readFloat()).setInvertHealAndHarm(buffer.readBoolean()).removeComponents(Component.CAMPFIRE_ITEM, Component.LANTERN_BLOCK, Component.LANTERN_ITEM, Component.TORCH_BLOCK, Component.TORCH_ITEM, Component.WALL_TORCH_BLOCK, Component.FLAME_PARTICLE);
            if (buffer.readBoolean()) {
                builder.setComponent(Component.SOURCE_BLOCK, buffer.method_10810());
            } else {
                builder.removeComponent(Component.SOURCE_BLOCK);
            }
            if (buffer.readBoolean()) {
                builder.setComponent(Component.CAMPFIRE_BLOCK, buffer.method_10810());
            } else {
                builder.removeComponent(Component.CAMPFIRE_BLOCK);
            }
            return builder.build();
        }
    };
    private final class_2960 fireType;
    private final int light;
    private final float damage;
    private final boolean invertHealAndHarm;
    private final boolean canRainDouse;
    private final Function<class_1297, class_1282> onCampfireGetter;
    private final Function<class_1297, class_1282> inFireGetter;
    private final Function<class_1297, class_1282> onFireGetter;
    private final Predicate<class_1297> behavior;
    private final ImmutableMap<Component<?, ?>, class_2960> components;

    Fire(class_2960 fireType, int light, float damage, boolean invertHealAndHarm, boolean canRainDouse, Function<class_1297, class_1282> onCampfireGetter, Function<class_1297, class_1282> inFireGetter, Function<class_1297, class_1282> onFireGetter, Predicate<class_1297> behavior, Map<Component<?, ?>, class_2960> components) {
        this.fireType = fireType;
        this.light = light;
        this.damage = damage;
        this.invertHealAndHarm = invertHealAndHarm;
        this.canRainDouse = canRainDouse;
        this.onCampfireGetter = onCampfireGetter;
        this.inFireGetter = inFireGetter;
        this.onFireGetter = onFireGetter;
        this.behavior = behavior;
        this.components = ImmutableMap.copyOf(components);
    }

    public class_2960 getFireType() {
        return this.fireType;
    }

    public int getLight() {
        return this.light;
    }

    public float getDamage() {
        return this.damage;
    }

    public boolean invertHealAndHarm() {
        return this.invertHealAndHarm;
    }

    public boolean canRainDouse() {
        return this.canRainDouse;
    }

    public class_1282 getOnCampfire(class_1297 entity) {
        return this.onCampfireGetter.apply(entity);
    }

    public class_1282 getInFire(class_1297 entity) {
        return this.inFireGetter.apply(entity);
    }

    public class_1282 getOnFire(class_1297 entity) {
        return this.onFireGetter.apply(entity);
    }

    public Predicate<class_1297> getBehavior() {
        return this.behavior;
    }

    @Nullable
    public class_2960 getComponent(Component<?, ?> component) {
        return (class_2960)this.components.get(component);
    }

    public String toString() {
        return "Fire{fireType=" + String.valueOf(this.fireType) + ", light=" + this.light + ", damage=" + this.damage + ", invertHealAndHarm=" + this.invertHealAndHarm + ", canRainDouse=" + this.canRainDouse + ", components=" + String.valueOf(this.components) + "}";
    }

    public static final class Builder {
        public static final int DEFAULT_LIGHT = 15;
        public static final float DEFAULT_DAMAGE = 1.0f;
        public static final boolean DEFAULT_INVERT_HEAL_AND_HARM = false;
        public static final boolean DEFAULT_CAN_RAIN_DOUSE = false;
        public static final Function<class_1297, class_1282> DEFAULT_ON_CAMPFIRE_GETTER = entity -> entity.method_48923().method_59917();
        public static final Function<class_1297, class_1282> DEFAULT_IN_FIRE_GETTER = entity -> entity.method_48923().method_48794();
        public static final Function<class_1297, class_1282> DEFAULT_ON_FIRE_GETTER = entity -> entity.method_48923().method_48813();
        public static final Predicate<class_1297> DEFAULT_BEHAVIOR = entity -> true;
        private String modId;
        private String fireId;
        private int light;
        private float damage;
        private boolean invertHealAndHarm;
        private boolean canRainDouse;
        private Function<class_1297, class_1282> onCampfireGetter;
        private Function<class_1297, class_1282> inFireGetter;
        private Function<class_1297, class_1282> onFireGetter;
        private Predicate<class_1297> behavior;
        private Map<Component<?, ?>, class_2960> components;

        Builder(String modId, String fireId) {
            this.reset(modId, fireId);
        }

        Builder(class_2960 fireType) {
            this.reset(fireType);
        }

        @Nullable
        private static <T> T get(@Nullable Optional<T> optional) {
            return optional != null && optional.isPresent() ? (T)optional.get() : null;
        }

        public Builder setLight(int light) {
            if (light >= 0 && light <= 15) {
                this.light = light;
            }
            return this;
        }

        public Builder setDamage(float damage) {
            this.damage = damage;
            return this;
        }

        public Builder setInvertHealAndHarm(boolean invertHealAndHarm) {
            this.invertHealAndHarm = invertHealAndHarm;
            return this;
        }

        public Builder setCanRainDouse(boolean canRainDouse) {
            this.canRainDouse = canRainDouse;
            return this;
        }

        public Builder setOnCampfire(Function<class_1297, class_1282> getter) {
            this.onCampfireGetter = getter;
            return this;
        }

        public Builder setInFire(Function<class_1297, class_1282> getter) {
            this.inFireGetter = getter;
            return this;
        }

        public Builder setOnFire(Function<class_1297, class_1282> getter) {
            this.onFireGetter = getter;
            return this;
        }

        public Builder setBehavior(@NotNull Predicate<class_1297> behavior) {
            this.behavior = behavior;
            return this;
        }

        public Builder setBehavior(@NotNull Consumer<class_1297> behavior) {
            this.behavior = entity -> {
                behavior.accept((class_1297)entity);
                return true;
            };
            return this;
        }

        public Builder setComponent(Component<?, ?> component, class_2960 id) {
            this.components.put(component, id);
            return this;
        }

        public Builder setDefaultComponents() {
            this.components = new HashMap(Map.ofEntries(Component.SOURCE_BLOCK.getEntry(this.modId, this.fireId), Component.CAMPFIRE_BLOCK.getEntry(this.modId, this.fireId), Component.CAMPFIRE_ITEM.getEntry(this.modId, this.fireId), Component.LANTERN_BLOCK.getEntry(this.modId, this.fireId), Component.LANTERN_ITEM.getEntry(this.modId, this.fireId), Component.TORCH_BLOCK.getEntry(this.modId, this.fireId), Component.TORCH_ITEM.getEntry(this.modId, this.fireId), Component.WALL_TORCH_BLOCK.getEntry(this.modId, this.fireId), Component.FLAME_PARTICLE.getEntry(this.modId, this.fireId)));
            return this;
        }

        public Builder removeComponent(Component<?, ?> component) {
            this.components.remove(component);
            return this;
        }

        public Builder removeComponents(Component<?, ?> ... components) {
            for (Component<?, ?> component : components) {
                this.components.remove(component);
            }
            return this;
        }

        public Builder reset(class_2960 fireType) {
            return this.reset(fireType.method_12836(), fireType.method_12832());
        }

        public Builder reset(String modId, String fireId) {
            this.modId = modId;
            return this.reset(fireId);
        }

        public Builder reset(String fireId) {
            this.fireId = fireId;
            this.light = 15;
            this.damage = 1.0f;
            this.invertHealAndHarm = false;
            this.canRainDouse = false;
            this.onCampfireGetter = DEFAULT_ON_CAMPFIRE_GETTER;
            this.inFireGetter = DEFAULT_IN_FIRE_GETTER;
            this.onFireGetter = DEFAULT_ON_FIRE_GETTER;
            this.behavior = DEFAULT_BEHAVIOR;
            this.components = new HashMap();
            return this;
        }

        public Fire build() throws IllegalStateException {
            if (FireManager.isValidFireId(this.fireId) && FireManager.isValidModId(this.modId)) {
                return new Fire(FireManager.sanitize(this.modId, this.fireId), this.light, this.damage, this.invertHealAndHarm, this.canRainDouse, this.onCampfireGetter, this.inFireGetter, this.onFireGetter, this.behavior, this.components);
            }
            throw new IllegalStateException("Attempted to build a Fire with a non-valid fireId [" + this.fireId + "] or modId [" + this.modId + "].");
        }
    }

    public static final class Component<R, T extends R> {
        public static final Component<class_2248, class_2248> SOURCE_BLOCK = new Component(class_7924.field_41254, "_fire");
        public static final Component<class_2248, class_2248> CAMPFIRE_BLOCK = new Component(class_7924.field_41254, "_campfire");
        public static final Component<class_1792, class_1747> CAMPFIRE_ITEM = new Component(class_7924.field_41197, "_campfire");
        public static final Component<class_2248, class_2248> LANTERN_BLOCK = new Component(class_7924.field_41254, "_lantern");
        public static final Component<class_1792, class_1747> LANTERN_ITEM = new Component(class_7924.field_41197, "_lantern");
        public static final Component<class_2248, class_2248> TORCH_BLOCK = new Component(class_7924.field_41254, "_torch");
        public static final Component<class_1792, class_1827> TORCH_ITEM = new Component(class_7924.field_41197, "_torch");
        public static final Component<class_2248, class_2248> WALL_TORCH_BLOCK = new Component(class_7924.field_41254, "_wall_torch");
        public static final Component<class_2396<?>, class_2400> FLAME_PARTICLE = new Component(class_7924.field_41210, "_flame");
        private final class_5321<? extends class_2378<R>> key;
        private final String suffix;

        private Component(class_5321<? extends class_2378<R>> key, String suffix) {
            this.key = key;
            this.suffix = suffix;
        }

        @NotNull
        class_2378<R> getRegistry() {
            return (class_2378)class_7923.field_41167.method_10223(this.key.method_29177());
        }

        @Nullable
        T getValue(class_2960 id) {
            return (T)this.getRegistry().method_10223(id);
        }

        @Nullable
        T getValue(Fire fire) {
            return this.getValue(fire.getComponent(this));
        }

        Optional<T> getOptionalValue(class_2960 id) {
            return this.getRegistry().method_17966(id);
        }

        Optional<T> getOptionalValue(Fire fire) {
            return this.getOptionalValue(fire.getComponent(this));
        }

        Map.Entry<Component<R, T>, class_2960> getEntry(String modId, String fireId) {
            return Map.entry(this, class_2960.method_60655((String)modId, (String)(fireId + this.suffix)));
        }
    }
}

