/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.api;

import it.crystalnest.cobweb.api.block.entity.DynamicBlockEntityType;
import it.crystalnest.cobweb.api.pack.dynamic.DynamicDataPack;
import it.crystalnest.cobweb.api.pack.dynamic.DynamicTagBuilder;
import it.crystalnest.cobweb.api.registry.CobwebEntry;
import it.crystalnest.cobweb.api.registry.CobwebRegister;
import it.crystalnest.cobweb.api.registry.CobwebRegistry;
import it.crystalnest.prometheus.Constants;
import it.crystalnest.prometheus.api.Fire;
import it.crystalnest.prometheus.api.block.CustomCampfireBlock;
import it.crystalnest.prometheus.api.block.CustomFireBlock;
import it.crystalnest.prometheus.api.block.CustomLanternBlock;
import it.crystalnest.prometheus.api.block.CustomTorchBlock;
import it.crystalnest.prometheus.api.block.CustomWallTorchBlock;
import it.crystalnest.prometheus.api.block.entity.CustomCampfireBlockEntity;
import it.crystalnest.prometheus.api.type.FireTypeChanger;
import it.crystalnest.prometheus.api.type.FireTyped;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1827;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FireManager {
    public static final String FIRE_TYPE_TAG = "FireType";
    public static final class_2960 DEFAULT_FIRE_TYPE = class_2960.method_60656((String)"");
    public static final Fire DEFAULT_FIRE = new Fire(DEFAULT_FIRE_TYPE, 15, 1.0f, false, true, Fire.Builder.DEFAULT_ON_CAMPFIRE_GETTER, Fire.Builder.DEFAULT_IN_FIRE_GETTER, Fire.Builder.DEFAULT_ON_FIRE_GETTER, Fire.Builder.DEFAULT_BEHAVIOR, Map.ofEntries(Map.entry(Fire.Component.SOURCE_BLOCK, class_7923.field_41175.method_10221((Object)class_2246.field_10036)), Map.entry(Fire.Component.CAMPFIRE_BLOCK, class_7923.field_41175.method_10221((Object)class_2246.field_17350)), Map.entry(Fire.Component.LANTERN_BLOCK, class_7923.field_41175.method_10221((Object)class_2246.field_16541)), Map.entry(Fire.Component.TORCH_BLOCK, class_7923.field_41175.method_10221((Object)class_2246.field_10336)), Map.entry(Fire.Component.WALL_TORCH_BLOCK, class_7923.field_41175.method_10221((Object)class_2246.field_10099)), Map.entry(Fire.Component.FLAME_PARTICLE, class_7923.field_41180.method_10221((Object)class_2398.field_11240))));
    public static final CobwebEntry<DynamicBlockEntityType<CustomCampfireBlockEntity>> CUSTOM_CAMPFIRE_ENTITY_TYPE = CobwebRegistry.of((class_5321)class_7924.field_41255, (String)"prometheus").register("custom_campfire", () -> DynamicBlockEntityType.of(CustomCampfireBlockEntity::new, state -> FireManager.getComponentList(Fire.Component.CAMPFIRE_BLOCK).stream().filter(CustomCampfireBlock.class::isInstance).toList().contains(state.method_26204())));
    private static final DynamicDataPack FIRE_SOURCE_TAGS = DynamicDataPack.named((class_2960)class_2960.method_60655((String)"prometheus", (String)"fire_source_tags"));
    private static final DynamicDataPack CAMPFIRE_TAGS = DynamicDataPack.named((class_2960)class_2960.method_60655((String)"prometheus", (String)"campfire_tags"));
    private static final ConcurrentHashMap<class_2960, Fire> FIRES = new ConcurrentHashMap();
    private static boolean LOADED = false;

    @ApiStatus.Internal
    public static synchronized void load() {
        if (LOADED) {
            throw new IllegalStateException("FireManager was already loaded");
        }
        LOADED = true;
    }

    private FireManager() {
    }

    public static Fire.Builder fireBuilder(String modId, String fireId) {
        return new Fire.Builder(modId, fireId);
    }

    public static Fire.Builder fireBuilder(class_2960 fireType) {
        return new Fire.Builder(fireType);
    }

    @Nullable
    public static synchronized Fire registerFire(Fire fire) {
        Fire previous = FIRES.computeIfAbsent(fire.getFireType(), key -> {
            Fire.Component.SOURCE_BLOCK.getOptionalValue(fire).ifPresent(FireManager.setTypeOrWarn(key));
            Fire.Component.CAMPFIRE_BLOCK.getOptionalValue(fire).ifPresent(FireManager.setTypeOrWarn(key));
            return fire;
        });
        if (previous != fire) {
            class_2960 fireType = fire.getFireType();
            Constants.LOGGER.error("Fire [{}] was already registered with the following value: {}", (Object)fireType, (Object)FireManager.getFire(fireType));
            return null;
        }
        return fire;
    }

    @NotNull
    private static Consumer<class_2248> setTypeOrWarn(class_2960 fireType) {
        return block -> {
            if (block instanceof FireTypeChanger) {
                FireTypeChanger fireTypeChanger = (FireTypeChanger)block;
                fireTypeChanger.setFireType(fireType);
            } else {
                Constants.LOGGER.warn("Could not set Fire Type [{}] for block [{}]\nThings might not work as expected!\nYou can ignore this warning if this was intended", (Object)fireType, block);
            }
        };
    }

    public static synchronized Map<class_2960, @Nullable Fire> registerFires(Fire ... fires) {
        return FireManager.registerFires(List.of(fires));
    }

    public static synchronized Map<class_2960, @Nullable Fire> registerFires(List<Fire> fires) {
        HashMap<class_2960, @Nullable Fire> outcomes = new HashMap<class_2960, Fire>();
        for (Fire fire : fires) {
            outcomes.put(fire.getFireType(), FireManager.registerFire(fire));
        }
        return outcomes;
    }

    @Nullable
    @ApiStatus.Internal
    public static synchronized Fire unregisterFire(class_2960 fireType) {
        return FIRES.remove(fireType);
    }

    public static <T extends CustomFireBlock> CobwebEntry<T> registerFireSource(class_2960 fireType, class_3620 color, BiFunction<class_2960, class_4970.class_2251, T> constructor) {
        CobwebEntry source = CobwebRegistry.ofBlocks((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.SOURCE_BLOCK), () -> (CustomFireBlock)constructor.apply(fireType, class_4970.class_2251.method_9637().method_31710(color)));
        FIRE_SOURCE_TAGS.add(new Supplier[]{() -> DynamicTagBuilder.of((class_5321)class_7924.field_41254, (class_6862[])new class_6862[]{class_3481.field_21952}).addElement((Object)((class_2248)source.get()))});
        return source;
    }

    public static <T extends CustomFireBlock> CobwebEntry<T> registerFireSource(class_2960 fireType, class_6862<class_2248> base, class_3620 color, TriFunction<class_2960, class_6862<class_2248>, class_4970.class_2251, T> constructor) {
        return FireManager.registerFireSource(fireType, color, (type, properties) -> (CustomFireBlock)constructor.apply(type, (Object)base, properties));
    }

    public static <T extends CustomCampfireBlock> CobwebEntry<T> registerCampfire(class_2960 fireType, BiFunction<class_2960, class_4970.class_2251, T> constructor) {
        CobwebEntry campfire = CobwebRegistry.ofBlocks((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.CAMPFIRE_BLOCK), () -> (CustomCampfireBlock)constructor.apply(fireType, class_4970.class_2251.method_9637()));
        FIRE_SOURCE_TAGS.add(new Supplier[]{() -> DynamicTagBuilder.of((class_5321)class_7924.field_41254, (class_6862[])new class_6862[]{class_3481.field_23799}).addElement((Object)((class_2248)campfire.get()))});
        return campfire;
    }

    public static <T extends CustomCampfireBlock> CobwebEntry<T> registerCampfire(class_2960 fireType, boolean spawnParticles, TriFunction<class_2960, Boolean, class_4970.class_2251, T> constructor) {
        return FireManager.registerCampfire(fireType, (type, properties) -> (CustomCampfireBlock)constructor.apply(type, (Object)spawnParticles, properties));
    }

    public static CobwebEntry<class_1747> registerCampfireItem(class_2960 fireType) {
        return FireManager.registerCampfireItem(fireType, class_1747::new);
    }

    public static <T extends class_1747> CobwebEntry<T> registerCampfireItem(class_2960 fireType, BiFunction<class_2248, class_1792.class_1793, T> supplier) {
        return CobwebRegistry.ofItems((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.CAMPFIRE_ITEM), () -> (class_1747)supplier.apply(FireManager.getRequiredComponent(fireType, Fire.Component.CAMPFIRE_BLOCK), new class_1792.class_1793()));
    }

    public static CobwebEntry<class_2400> registerParticle(class_2960 fireType) {
        return FireManager.registerParticle(fireType, () -> new class_2400(false));
    }

    public static <T extends class_2400> CobwebEntry<T> registerParticle(class_2960 fireType, Supplier<T> supplier) {
        return CobwebRegistry.of((class_5321)class_7924.field_41210, (String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.FLAME_PARTICLE), supplier);
    }

    public static Pair<CobwebEntry<CustomTorchBlock>, CobwebEntry<CustomWallTorchBlock>> registerTorch(class_2960 fireType) {
        return FireManager.registerTorch(fireType, CustomTorchBlock::new, CustomWallTorchBlock::new);
    }

    public static <T extends CustomTorchBlock, W extends CustomWallTorchBlock> Pair<CobwebEntry<T>, CobwebEntry<W>> registerTorch(class_2960 fireType, TriFunction<class_2960, Supplier<class_2400>, class_4970.class_2251, T> torchSupplier, TriFunction<class_2960, Supplier<class_2400>, class_4970.class_2251, W> wallTorchSupplier) {
        CobwebRegister blocks = CobwebRegistry.ofBlocks((String)FireManager.fireMod(fireType));
        return Pair.of((Object)blocks.register(FireManager.getComponentPath(fireType, Fire.Component.TORCH_BLOCK), () -> (CustomTorchBlock)torchSupplier.apply((Object)fireType, () -> FireManager.getRequiredComponent(fireType, Fire.Component.FLAME_PARTICLE), (Object)class_4970.class_2251.method_9637())), (Object)blocks.register(FireManager.getComponentPath(fireType, Fire.Component.WALL_TORCH_BLOCK), () -> (CustomWallTorchBlock)wallTorchSupplier.apply((Object)fireType, () -> FireManager.getRequiredComponent(fireType, Fire.Component.FLAME_PARTICLE), (Object)class_4970.class_2251.method_9637())));
    }

    public static <T extends class_1827> CobwebEntry<T> registerTorchItem(class_2960 fireType, BiFunction<class_2248, class_2248, T> supplier) {
        return CobwebRegistry.ofItems((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.TORCH_ITEM), () -> (class_1827)supplier.apply(FireManager.getRequiredComponent(fireType, Fire.Component.TORCH_BLOCK), FireManager.getRequiredComponent(fireType, Fire.Component.WALL_TORCH_BLOCK)));
    }

    public static CobwebEntry<class_1827> registerTorchItem(class_2960 fireType) {
        return FireManager.registerTorchItem(fireType, (torch, wallTorch, properties) -> new class_1827(torch, wallTorch, properties, class_2350.field_11033));
    }

    public static <T extends class_1827> CobwebEntry<T> registerTorchItem(class_2960 fireType, TriFunction<class_2248, class_2248, class_1792.class_1793, T> constructor) {
        return FireManager.registerTorchItem(fireType, constructor, new class_1792.class_1793());
    }

    public static <T extends class_1827> CobwebEntry<T> registerTorchItem(class_2960 fireType, TriFunction<class_2248, class_2248, class_1792.class_1793, T> constructor, class_1792.class_1793 properties) {
        return CobwebRegistry.ofItems((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.TORCH_ITEM), () -> (class_1827)constructor.apply((Object)FireManager.getRequiredComponent(fireType, Fire.Component.TORCH_BLOCK), (Object)FireManager.getRequiredComponent(fireType, Fire.Component.WALL_TORCH_BLOCK), (Object)properties));
    }

    public static CobwebEntry<CustomLanternBlock> registerLantern(class_2960 fireType) {
        return FireManager.registerLantern(fireType, CustomLanternBlock::new);
    }

    public static <T extends CustomLanternBlock> CobwebEntry<T> registerLantern(class_2960 fireType, BiFunction<class_2960, class_4970.class_2251, T> supplier) {
        return CobwebRegistry.ofBlocks((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.LANTERN_BLOCK), () -> (CustomLanternBlock)supplier.apply(fireType, class_4970.class_2251.method_9637()));
    }

    public static CobwebEntry<class_1747> registerLanternItem(class_2960 fireType) {
        return FireManager.registerLanternItem(fireType, class_1747::new);
    }

    public static <T extends class_1747> CobwebEntry<T> registerLanternItem(class_2960 fireType, BiFunction<class_2248, class_1792.class_1793, T> constructor) {
        return FireManager.registerLanternItem(fireType, constructor, new class_1792.class_1793());
    }

    public static <T extends class_1747> CobwebEntry<T> registerLanternItem(class_2960 fireType, BiFunction<class_2248, class_1792.class_1793, T> constructor, class_1792.class_1793 properties) {
        return CobwebRegistry.ofItems((String)FireManager.fireMod(fireType)).register(FireManager.getComponentPath(fireType, Fire.Component.LANTERN_ITEM), () -> (class_1747)constructor.apply(FireManager.getRequiredComponent(fireType, Fire.Component.LANTERN_BLOCK), properties));
    }

    public static Fire getFire(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId) ? FireManager.getFire(FireManager.fireType(modId, fireId)) : DEFAULT_FIRE;
    }

    public static Fire getFire(@Nullable class_2960 fireType) {
        return FIRES.getOrDefault(FireManager.ensure(fireType), DEFAULT_FIRE);
    }

    public static List<Fire> getFires() {
        return FIRES.values().stream().toList();
    }

    public static <T> T getProperty(class_2960 fireType, Function<Fire, T> getter) {
        return getter.apply(FireManager.getFire(fireType));
    }

    public static class_1282 getDamageSource(class_1297 entity, class_2960 fireType, BiFunction<Fire, class_1297, class_1282> getter) {
        return getter.apply(FireManager.getFire(fireType), entity);
    }

    @Nullable
    public static class_2960 getComponentId(class_2960 fireType, Fire.Component<?, ?> component) {
        return FireManager.getFire(fireType).getComponent(component);
    }

    @Nullable
    public static <R, T extends R> T getComponent(class_2960 fireType, Fire.Component<R, T> component) {
        return component.getValue(FireManager.getComponentId(fireType, component));
    }

    @NotNull
    private static String getComponentPath(class_2960 fireType, Fire.Component<?, ?> component) {
        return Objects.requireNonNull(FireManager.getComponentId(fireType, component)).method_12832();
    }

    @NotNull
    public static <R, T extends R> T getRequiredComponent(class_2960 fireType, Fire.Component<R, T> component) throws NullPointerException {
        return Objects.requireNonNull(component.getValue(FireManager.getComponentId(fireType, component)));
    }

    public static <T> List<T> getPropertyList(Function<Fire, T> getter) {
        return FIRES.values().stream().map(getter).toList();
    }

    public static List<class_2960> getComponentIdList(Fire.Component<?, ?> component) {
        return FIRES.values().stream().map(fire -> fire.getComponent(component)).filter(Objects::nonNull).toList();
    }

    public static <R, T extends R> List<T> getComponentList(Fire.Component<R, T> component) {
        return FIRES.values().stream().map(component::getValue).filter(Objects::nonNull).toList();
    }

    public static boolean isValidType(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId);
    }

    public static boolean isValidType(@Nullable class_2960 fireType) {
        return fireType != null && Strings.isNotBlank((String)FireManager.fireMod(fireType)) && Strings.isNotBlank((String)fireType.method_12832());
    }

    public static boolean isRegisteredType(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId) && FireManager.isRegisteredType(FireManager.fireType(modId, fireId));
    }

    public static boolean isRegisteredType(@Nullable class_2960 fireType) {
        return fireType != null && FIRES.containsKey(fireType);
    }

    public static boolean isValidFireId(@Nullable String fireId) {
        return Strings.isNotBlank((String)fireId) && class_2960.method_20208((String)fireId);
    }

    public static boolean isRegisteredFireId(@Nullable String fireId) {
        return FireManager.isValidFireId(fireId) && FIRES.keySet().stream().anyMatch(fireType -> fireType.method_12832().equals(fireId));
    }

    public static boolean isValidModId(@Nullable String modId) {
        return Strings.isNotBlank((String)modId) && class_2960.method_20209((String)modId);
    }

    public static boolean isRegisteredModId(@Nullable String modId) {
        return FireManager.isValidModId(modId) && FIRES.keySet().stream().anyMatch(fireType -> FireManager.fireMod(fireType).equals(modId));
    }

    public static class_2960 sanitize(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidModId(fireId) ? FireManager.sanitize(FireManager.fireType(modId, fireId)) : DEFAULT_FIRE_TYPE;
    }

    public static class_2960 sanitize(@Nullable class_2960 fireType) {
        return FireManager.isValidType(fireType) ? fireType : DEFAULT_FIRE_TYPE;
    }

    public static class_2960 ensure(@Nullable String modId, @Nullable String fireId) {
        String trimmedModId = modId == null ? "" : modId.trim();
        String trimmedFireId = fireId == null ? "" : fireId.trim();
        return FireManager.isValidModId(trimmedModId) && FireManager.isValidFireId(trimmedFireId) ? FireManager.ensure(class_2960.method_60655((String)trimmedModId, (String)trimmedFireId)) : DEFAULT_FIRE_TYPE;
    }

    public static class_2960 ensure(@Nullable class_2960 fireType) {
        return FireManager.isRegisteredType(fireType) ? fireType : DEFAULT_FIRE_TYPE;
    }

    public static List<class_2960> getFireTypes() {
        return FIRES.keySet().stream().toList();
    }

    public static List<String> getFireIds() {
        return FIRES.keySet().stream().map(class_2960::method_12832).toList();
    }

    public static List<String> getModIds() {
        return FIRES.keySet().stream().map(class_2960::method_12836).toList();
    }

    public static void writeTag(class_2487 tag, @Nullable class_2960 fireType) {
        tag.method_10582(FIRE_TYPE_TAG, FireManager.ensure(fireType).toString());
    }

    public static class_2960 readTag(class_2487 tag) {
        return FireManager.ensure(class_2960.method_12829((String)tag.method_10558(FIRE_TYPE_TAG)));
    }

    public static void setOnFire(class_1297 entity, float seconds, class_2960 fireType) {
        FireManager.setOnFire(entity, seconds, fireType, class_1297::method_5639);
    }

    @ApiStatus.Internal
    public static void setOnFire(class_1297 entity, float seconds, class_2960 fireType, BiConsumer<class_1297, Float> setOnFireFunction) {
        setOnFireFunction.accept(entity, Float.valueOf(seconds));
        ((FireTypeChanger)entity).setFireType(FireManager.ensure(fireType));
    }

    public static boolean affect(class_1297 entity, class_2960 fireType, BiFunction<Fire, class_1297, class_1282> damageSourceGetter) {
        return FireManager.affect(entity, fireType, damageSourceGetter, (TriFunction<class_1297, class_1282, Float, Boolean>)((TriFunction)class_1297::method_5643));
    }

    @ApiStatus.Internal
    public static boolean affect(class_1297 entity, class_2960 fireType, BiFunction<Fire, class_1297, class_1282> damageSourceGetter, TriFunction<class_1297, class_1282, Float, Boolean> hurtFunction) {
        ((FireTypeChanger)entity).setFireType(FireManager.ensure(fireType));
        return FireManager.affect(entity, FireManager.getDamageSource(entity, fireType, damageSourceGetter), FireManager.getProperty(fireType, Fire::getDamage).floatValue(), FireManager.getProperty(fireType, Fire::invertHealAndHarm), hurtFunction);
    }

    private static boolean affect(class_1297 entity, class_1282 damageSource, float damage, boolean invertHealAndHarm, TriFunction<class_1297, class_1282, Float, Boolean> hurtFunction) {
        Predicate behavior = FireManager.getProperty(((FireTyped)entity).getFireType(), Fire::getBehavior);
        if (behavior.test(entity) && Float.compare(damage, 0.0f) != 0) {
            if (damage > 0.0f) {
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    if (livingEntity.method_5999() && invertHealAndHarm) {
                        livingEntity.method_6025(damage);
                        return false;
                    }
                    return (Boolean)hurtFunction.apply((Object)livingEntity, (Object)damageSource, (Object)Float.valueOf(damage));
                }
                return (Boolean)hurtFunction.apply((Object)entity, (Object)damageSource, (Object)Float.valueOf(damage));
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (livingEntity.method_5999() && invertHealAndHarm) {
                    return (Boolean)hurtFunction.apply((Object)livingEntity, (Object)damageSource, (Object)Float.valueOf(-damage));
                }
                livingEntity.method_6025(-damage);
                return false;
            }
        }
        return false;
    }

    private static class_2960 fireType(@Nullable String modId, @Nullable String fireId) {
        return class_2960.method_60655((String)Objects.requireNonNull(modId), (String)Objects.requireNonNull(fireId));
    }

    private static String fireMod(class_2960 fireType) {
        return fireType.method_12836();
    }

    public static int light(class_2960 fireType) {
        return FireManager.getProperty(fireType, Fire::getLight);
    }

    static {
        FIRE_SOURCE_TAGS.register();
        CAMPFIRE_TAGS.register();
    }
}

