/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.handler;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.crystalnest.prometheus.Constants;
import it.crystalnest.prometheus.api.Fire;
import it.crystalnest.prometheus.api.FireManager;
import it.crystalnest.prometheus.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FireResourceReloadListener
extends SimpleJsonResourceReloadListener<DDFires> {
    private static final ArrayList<ResourceLocation> ddfiresUnregister = new ArrayList();
    private static final ArrayList<ResourceLocation> ddfiresRegister = new ArrayList();

    public FireResourceReloadListener() {
        super(DDFires.CODEC, FileToIdConverter.json((String)"fires"));
    }

    public static void handle(@Nullable ServerPlayer player) {
        for (ResourceLocation fireType : ddfiresUnregister) {
            Services.NETWORK.sendToClient(player, fireType);
        }
        for (ResourceLocation fireType : ddfiresRegister) {
            Services.NETWORK.sendToClient(player, FireManager.getFire(fireType));
        }
    }

    private static void unregisterFires() {
        for (ResourceLocation fireType : ddfiresRegister) {
            if (FireManager.unregisterFire(fireType) == null) continue;
            ddfiresUnregister.add(fireType);
        }
        ddfiresRegister.clear();
    }

    private static void registerFire(ResourceLocation fireType, Fire fire) {
        if (FireManager.registerFire(fire) != null) {
            ddfiresRegister.add(fireType);
        } else {
            Constants.LOGGER.error("Unable to register ddfire [{}].", (Object)fireType);
        }
    }

    protected void apply(@NotNull Map<ResourceLocation, DDFires> resourceLocationDDFiresMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        FireResourceReloadListener.unregisterFires();
        for (Map.Entry<ResourceLocation, DDFires> entry : resourceLocationDDFiresMap.entrySet()) {
            DDFires fires = entry.getValue();
            if (Services.PLATFORM.isModLoaded(fires.mod)) {
                for (DDFire fire : fires.fires) {
                    ResourceLocation fireType = ResourceLocation.fromNamespaceAndPath((String)fires.mod, (String)fire.fire);
                    Fire.Builder builder = FireManager.fireBuilder(fireType).setDamage(fire.damage.orElse(Float.valueOf(1.0f)).floatValue()).setInvertHealAndHarm(fire.invertHealAndHarm.orElse(false)).removeComponents(Fire.Component.CAMPFIRE_ITEM, Fire.Component.LANTERN_BLOCK, Fire.Component.LANTERN_ITEM, Fire.Component.TORCH_BLOCK, Fire.Component.TORCH_ITEM, Fire.Component.WALL_TORCH_BLOCK, Fire.Component.FLAME_PARTICLE);
                    this.removeOrSet(builder, fire.source, Fire.Component.SOURCE_BLOCK);
                    this.removeOrSet(builder, fire.campfire, Fire.Component.CAMPFIRE_BLOCK);
                    FireResourceReloadListener.registerFire(fireType, builder.build());
                }
                continue;
            }
            Constants.LOGGER.warn("Registering of ddfires for [{}] is canceled: {} is not loaded.", (Object)fires.mod, (Object)fires.mod);
        }
    }

    private void removeOrSet(Fire.Builder builder, Optional<ResourceLocation> reference, Fire.Component<?, ?> component) {
        if (reference.isPresent()) {
            if ((reference.get().getNamespace().equalsIgnoreCase("minecraft") || reference.get().getNamespace().equalsIgnoreCase("prometheus")) && reference.get().getPath().equalsIgnoreCase("remove")) {
                builder.removeComponent(component);
            } else {
                builder.setComponent(component, reference.get());
            }
        }
    }

    protected record DDFires(String mod, List<DDFire> fires) {
        private static final Codec<DDFires> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("mod").forGetter(ddFires -> ddFires.mod), (App)DDFire.CODEC.listOf().fieldOf("fires").forGetter(ddFires -> ddFires.fires)).apply((Applicative)instance, DDFires::new));
    }

    protected record DDFire(String fire, Optional<Float> damage, Optional<Boolean> invertHealAndHarm, Optional<ResourceLocation> source, Optional<ResourceLocation> campfire) {
        private static final Codec<DDFire> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("fire").forGetter(ddFire -> ddFire.fire), (App)Codec.FLOAT.optionalFieldOf("damage").forGetter(ddFire -> ddFire.damage), (App)Codec.BOOL.optionalFieldOf("invertHealAndHarm").forGetter(ddFire -> ddFire.invertHealAndHarm), (App)ResourceLocation.CODEC.optionalFieldOf("source").forGetter(ddFire -> ddFire.source), (App)ResourceLocation.CODEC.optionalFieldOf("campfire").forGetter(ddFire -> ddFire.campfire)).apply((Applicative)instance, DDFire::new));
    }
}

