/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.crystalnest.prometheus.api.Fire;
import it.crystalnest.prometheus.api.FireManager;
import it.crystalnest.prometheus.api.type.FireTypeChanger;
import it.crystalnest.prometheus.api.type.FireTyped;
import it.crystalnest.prometheus.platform.Services;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements FireTypeChanger {
    @Shadow
    private Level level;

    @Shadow
    public abstract int getRemainingFireTicks();

    @Shadow
    public abstract boolean fireImmune();

    @Override
    public ResourceLocation getFireType() {
        return Services.ATTACHMENT.getFireType((Entity)this);
    }

    @Override
    public void setFireType(ResourceLocation fireType) {
        if (!this.fireImmune()) {
            Services.ATTACHMENT.setFireType((Entity)this, fireType);
        }
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean wrapHurtServer(Entity instance, ServerLevel level, DamageSource damageSource, float damage, Operation<Boolean> original) {
        return FireManager.affect(instance, ((FireTyped)instance).getFireType(), Fire::getOnFire, (xva$0, xva$1, xva$2, xva$3) -> (Boolean)original.call(new Object[]{xva$0, xva$1, xva$2, xva$3}));
    }

    @WrapOperation(method={"lavaIgnite"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;igniteForSeconds(F)V")})
    private void wrapIgniteForSeconds(Entity instance, float seconds, Operation<Void> original) {
        FireManager.setOnFire(instance, seconds, FireManager.DEFAULT_FIRE_TYPE, (xva$0, xva$1) -> {
            Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0, xva$1});
        });
    }

    @Inject(method={"setRemainingFireTicks"}, at={@At(value="HEAD")})
    private void onSetRemainingFireTicks(int ticks, CallbackInfo ci) {
        if (!this.level.isClientSide() && ticks >= this.getRemainingFireTicks()) {
            this.setFireType(FireManager.DEFAULT_FIRE_TYPE);
        }
    }
}

