/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.api;

import com.google.common.collect.ImmutableMap;
import it.crystalnest.prometheus.api.FireManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Fire {
    public static final StreamCodec<FriendlyByteBuf, Fire> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, Fire>(){

        public void encode(FriendlyByteBuf buffer, Fire fire) {
            ResourceLocation campfire;
            buffer.writeResourceLocation(fire.getFireType());
            buffer.writeFloat(fire.getDamage());
            buffer.writeBoolean(fire.invertHealAndHarm());
            @Nullable ResourceLocation source = fire.getComponent(Component.SOURCE_BLOCK);
            buffer.writeBoolean(source != null);
            if (source != null) {
                buffer.writeResourceLocation(source);
            }
            buffer.writeBoolean((campfire = fire.getComponent(Component.CAMPFIRE_BLOCK)) != null);
            if (campfire != null) {
                buffer.writeResourceLocation(campfire);
            }
        }

        @NotNull
        public Fire decode(FriendlyByteBuf buffer) {
            Builder builder = FireManager.fireBuilder(buffer.readResourceLocation()).setDamage(buffer.readFloat()).setInvertHealAndHarm(buffer.readBoolean()).removeComponents(Component.CAMPFIRE_ITEM, Component.LANTERN_BLOCK, Component.LANTERN_ITEM, Component.TORCH_BLOCK, Component.TORCH_ITEM, Component.WALL_TORCH_BLOCK, Component.FLAME_PARTICLE);
            if (buffer.readBoolean()) {
                builder.setComponent(Component.SOURCE_BLOCK, buffer.readResourceLocation());
            } else {
                builder.removeComponent(Component.SOURCE_BLOCK);
            }
            if (buffer.readBoolean()) {
                builder.setComponent(Component.CAMPFIRE_BLOCK, buffer.readResourceLocation());
            } else {
                builder.removeComponent(Component.CAMPFIRE_BLOCK);
            }
            return builder.build();
        }
    };
    private final ResourceLocation fireType;
    private final int light;
    private final float damage;
    private final boolean invertHealAndHarm;
    private final boolean canRainDouse;
    private final Function<Entity, DamageSource> onCampfireGetter;
    private final Function<Entity, DamageSource> inFireGetter;
    private final Function<Entity, DamageSource> onFireGetter;
    private final Predicate<Entity> behavior;
    private final ImmutableMap<Component<?, ?>, ResourceLocation> components;

    Fire(ResourceLocation fireType, int light, float damage, boolean invertHealAndHarm, boolean canRainDouse, Function<Entity, DamageSource> onCampfireGetter, Function<Entity, DamageSource> inFireGetter, Function<Entity, DamageSource> onFireGetter, Predicate<Entity> behavior, Map<Component<?, ?>, ResourceLocation> components) {
        this.fireType = fireType;
        this.light = light;
        this.damage = damage;
        this.invertHealAndHarm = invertHealAndHarm;
        this.canRainDouse = canRainDouse;
        this.onCampfireGetter = onCampfireGetter;
        this.inFireGetter = inFireGetter;
        this.onFireGetter = onFireGetter;
        this.behavior = behavior;
        this.components = ImmutableMap.copyOf(components);
    }

    public ResourceLocation getFireType() {
        return this.fireType;
    }

    public int getLight() {
        return this.light;
    }

    public float getDamage() {
        return this.damage;
    }

    public boolean invertHealAndHarm() {
        return this.invertHealAndHarm;
    }

    public boolean canRainDouse() {
        return this.canRainDouse;
    }

    public DamageSource getOnCampfire(Entity entity) {
        return this.onCampfireGetter.apply(entity);
    }

    public DamageSource getInFire(Entity entity) {
        return this.inFireGetter.apply(entity);
    }

    public DamageSource getOnFire(Entity entity) {
        return this.onFireGetter.apply(entity);
    }

    public Predicate<Entity> getBehavior() {
        return this.behavior;
    }

    @Nullable
    public ResourceLocation getComponent(Component<?, ?> component) {
        return (ResourceLocation)this.components.get(component);
    }

    public String toString() {
        return "Fire{fireType=" + String.valueOf(this.fireType) + ", light=" + this.light + ", damage=" + this.damage + ", invertHealAndHarm=" + this.invertHealAndHarm + ", canRainDouse=" + this.canRainDouse + ", components=" + String.valueOf(this.components) + "}";
    }

    public static final class Builder {
        public static final int DEFAULT_LIGHT = 15;
        public static final float DEFAULT_DAMAGE = 1.0f;
        public static final boolean DEFAULT_INVERT_HEAL_AND_HARM = false;
        public static final boolean DEFAULT_CAN_RAIN_DOUSE = false;
        public static final Function<Entity, DamageSource> DEFAULT_ON_CAMPFIRE_GETTER = entity -> entity.damageSources().campfire();
        public static final Function<Entity, DamageSource> DEFAULT_IN_FIRE_GETTER = entity -> entity.damageSources().inFire();
        public static final Function<Entity, DamageSource> DEFAULT_ON_FIRE_GETTER = entity -> entity.damageSources().onFire();
        public static final Predicate<Entity> DEFAULT_BEHAVIOR = entity -> true;
        private String modId;
        private String fireId;
        private int light;
        private float damage;
        private boolean invertHealAndHarm;
        private boolean canRainDouse;
        private Function<Entity, DamageSource> onCampfireGetter;
        private Function<Entity, DamageSource> inFireGetter;
        private Function<Entity, DamageSource> onFireGetter;
        private Predicate<Entity> behavior;
        private Map<Component<?, ?>, ResourceLocation> components;

        Builder(String modId, String fireId) {
            this.reset(modId, fireId);
        }

        Builder(ResourceLocation fireType) {
            this.reset(fireType);
        }

        @Nullable
        private static <T> T get(@Nullable Optional<T> optional) {
            return optional != null && optional.isPresent() ? (T)optional.get() : null;
        }

        public Builder setLight(int light) {
            if (light >= 0 && light <= 15) {
                this.light = light;
            }
            return this;
        }

        public Builder setDamage(float damage) {
            this.damage = damage;
            return this;
        }

        public Builder setInvertHealAndHarm(boolean invertHealAndHarm) {
            this.invertHealAndHarm = invertHealAndHarm;
            return this;
        }

        public Builder setCanRainDouse(boolean canRainDouse) {
            this.canRainDouse = canRainDouse;
            return this;
        }

        public Builder setOnCampfire(Function<Entity, DamageSource> getter) {
            this.onCampfireGetter = getter;
            return this;
        }

        public Builder setInFire(Function<Entity, DamageSource> getter) {
            this.inFireGetter = getter;
            return this;
        }

        public Builder setOnFire(Function<Entity, DamageSource> getter) {
            this.onFireGetter = getter;
            return this;
        }

        public Builder setBehavior(@NotNull Predicate<Entity> behavior) {
            this.behavior = behavior;
            return this;
        }

        public Builder setBehavior(@NotNull Consumer<Entity> behavior) {
            this.behavior = entity -> {
                behavior.accept((Entity)entity);
                return true;
            };
            return this;
        }

        public Builder setComponent(Component<?, ?> component, ResourceLocation id) {
            this.components.put(component, id);
            return this;
        }

        public Builder setDefaultComponents() {
            this.components = new HashMap(Map.ofEntries(Component.SOURCE_BLOCK.getEntry(this.modId, this.fireId), Component.CAMPFIRE_BLOCK.getEntry(this.modId, this.fireId), Component.CAMPFIRE_ITEM.getEntry(this.modId, this.fireId), Component.LANTERN_BLOCK.getEntry(this.modId, this.fireId), Component.LANTERN_ITEM.getEntry(this.modId, this.fireId), Component.TORCH_BLOCK.getEntry(this.modId, this.fireId), Component.TORCH_ITEM.getEntry(this.modId, this.fireId), Component.WALL_TORCH_BLOCK.getEntry(this.modId, this.fireId), Component.FLAME_PARTICLE.getEntry(this.modId, this.fireId)));
            return this;
        }

        public Builder removeComponent(Component<?, ?> component) {
            this.components.remove(component);
            return this;
        }

        public Builder removeComponents(Component<?, ?> ... components) {
            for (Component<?, ?> component : components) {
                this.components.remove(component);
            }
            return this;
        }

        public Builder reset(ResourceLocation fireType) {
            return this.reset(fireType.getNamespace(), fireType.getPath());
        }

        public Builder reset(String modId, String fireId) {
            this.modId = modId;
            return this.reset(fireId);
        }

        public Builder reset(String fireId) {
            this.fireId = fireId;
            this.light = 15;
            this.damage = 1.0f;
            this.invertHealAndHarm = false;
            this.canRainDouse = false;
            this.onCampfireGetter = DEFAULT_ON_CAMPFIRE_GETTER;
            this.inFireGetter = DEFAULT_IN_FIRE_GETTER;
            this.onFireGetter = DEFAULT_ON_FIRE_GETTER;
            this.behavior = DEFAULT_BEHAVIOR;
            this.components = new HashMap();
            return this;
        }

        public Fire build() throws IllegalStateException {
            if (FireManager.isValidFireId(this.fireId) && FireManager.isValidModId(this.modId)) {
                return new Fire(FireManager.sanitize(this.modId, this.fireId), this.light, this.damage, this.invertHealAndHarm, this.canRainDouse, this.onCampfireGetter, this.inFireGetter, this.onFireGetter, this.behavior, this.components);
            }
            throw new IllegalStateException("Attempted to build a Fire with a non-valid fireId [" + this.fireId + "] or modId [" + this.modId + "].");
        }
    }

    public static final class Component<R, T extends R> {
        public static final Component<Block, Block> SOURCE_BLOCK = new Component(Registries.BLOCK, "_fire");
        public static final Component<Block, Block> CAMPFIRE_BLOCK = new Component(Registries.BLOCK, "_campfire");
        public static final Component<Item, BlockItem> CAMPFIRE_ITEM = new Component(Registries.ITEM, "_campfire");
        public static final Component<Block, Block> LANTERN_BLOCK = new Component(Registries.BLOCK, "_lantern");
        public static final Component<Item, BlockItem> LANTERN_ITEM = new Component(Registries.ITEM, "_lantern");
        public static final Component<Block, Block> TORCH_BLOCK = new Component(Registries.BLOCK, "_torch");
        public static final Component<Item, StandingAndWallBlockItem> TORCH_ITEM = new Component(Registries.ITEM, "_torch");
        public static final Component<Block, Block> WALL_TORCH_BLOCK = new Component(Registries.BLOCK, "_wall_torch");
        public static final Component<ParticleType<?>, SimpleParticleType> FLAME_PARTICLE = new Component(Registries.PARTICLE_TYPE, "_flame");
        private final ResourceKey<? extends Registry<R>> key;
        private final String suffix;

        private Component(ResourceKey<? extends Registry<R>> key, String suffix) {
            this.key = key;
            this.suffix = suffix;
        }

        @NotNull
        Registry<R> getRegistry() {
            return (Registry)BuiltInRegistries.REGISTRY.get(this.key.location());
        }

        @Nullable
        T getValue(ResourceLocation id) {
            return (T)this.getRegistry().get(id);
        }

        @Nullable
        T getValue(Fire fire) {
            return this.getValue(fire.getComponent(this));
        }

        Optional<T> getOptionalValue(ResourceLocation id) {
            return this.getRegistry().getOptional(id);
        }

        Optional<T> getOptionalValue(Fire fire) {
            return this.getOptionalValue(fire.getComponent(this));
        }

        Map.Entry<Component<R, T>, ResourceLocation> getEntry(String modId, String fireId) {
            return Map.entry(this, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(fireId + this.suffix)));
        }
    }
}

