/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.handler;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.crystalnest.prometheus.Constants;
import it.crystalnest.prometheus.api.Fire;
import it.crystalnest.prometheus.api.FireManager;
import it.crystalnest.prometheus.platform.Services;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireResourceReloadListener
extends class_4309 {
    private static final ArrayList<class_2960> ddfiresUnregister = new ArrayList();
    private static final ArrayList<class_2960> ddfiresRegister = new ArrayList();
    private static final String SOURCE_FIELD_NAME = "source";
    private static final String CAMPFIRE_FIELD_NAME = "campfire";

    public FireResourceReloadListener() {
        super(new Gson(), "fires");
    }

    public static void handle(@Nullable class_3222 player) {
        for (class_2960 fireType : ddfiresUnregister) {
            Services.NETWORK.sendToClient(player, fireType);
        }
        for (class_2960 fireType : ddfiresRegister) {
            Services.NETWORK.sendToClient(player, FireManager.getFire(fireType));
        }
    }

    private static JsonObject getJsonObject(String identifier, JsonElement element) throws IllegalStateException {
        try {
            return element.getAsJsonObject();
        }
        catch (IllegalStateException e) {
            Constants.LOGGER.error("prometheus encountered a non-blocking DDFire error!\nError parsing ddfire [{}]: not a JSON object.", (Object)identifier);
            throw e;
        }
    }

    private static <T> T parse(String identifier, String field, JsonObject data, Function<JsonElement, T> parser) throws NullPointerException, UnsupportedOperationException, IllegalStateException, NumberFormatException {
        try {
            return parser.apply(data.get(field));
        }
        catch (IllegalStateException | NullPointerException | NumberFormatException | UnsupportedOperationException e) {
            Constants.LOGGER.error("prometheus encountered a non-blocking DDFire error!\nError parsing required field \"{}\" for ddfire [{}]: missing or malformed field.", (Object)field, (Object)identifier);
            throw e;
        }
    }

    private static <T> T parse(String identifier, String field, JsonObject data, Function<JsonElement, T> parser, T fallback) throws UnsupportedOperationException, IllegalStateException, NumberFormatException {
        try {
            return parser.apply(data.get(field));
        }
        catch (NullPointerException e) {
            return fallback;
        }
        catch (IllegalStateException | NumberFormatException | UnsupportedOperationException e) {
            Constants.LOGGER.error("prometheus encountered a non-blocking DDFire error!\nError parsing optional field \"{}\" for ddfire [{}]: malformed field.", (Object)field, (Object)identifier);
            throw e;
        }
    }

    private static void unregisterFires() {
        for (class_2960 fireType : ddfiresRegister) {
            if (FireManager.unregisterFire(fireType) == null) continue;
            ddfiresUnregister.add(fireType);
        }
        ddfiresRegister.clear();
    }

    private static void registerFire(class_2960 fireType, Fire fire) {
        if (FireManager.registerFire(fire) != null) {
            ddfiresRegister.add(fireType);
        } else {
            Constants.LOGGER.error("Unable to register ddfire [{}].", (Object)fireType);
        }
    }

    private static void registerFire(JsonObject jsonFire, String mod, String jsonIdentifier) {
        class_2960 fireType = class_2960.method_60655((String)mod, (String)FireResourceReloadListener.parse(jsonIdentifier, "fire", jsonFire, JsonElement::getAsString));
        String fireTypeString = fireType.toString();
        Fire.Builder builder = FireManager.fireBuilder(fireType).setDamage(FireResourceReloadListener.parse(fireTypeString, "damage", jsonFire, JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue()).setInvertHealAndHarm(FireResourceReloadListener.parse(fireTypeString, "invertHealAndHarm", jsonFire, JsonElement::getAsBoolean, false)).removeComponents(Fire.Component.CAMPFIRE_ITEM, Fire.Component.LANTERN_BLOCK, Fire.Component.LANTERN_ITEM, Fire.Component.TORCH_BLOCK, Fire.Component.TORCH_ITEM, Fire.Component.WALL_TORCH_BLOCK, Fire.Component.FLAME_PARTICLE);
        FireResourceReloadListener.removeOrSet(fireTypeString, builder, jsonFire, SOURCE_FIELD_NAME, Fire.Component.SOURCE_BLOCK);
        FireResourceReloadListener.removeOrSet(fireTypeString, builder, jsonFire, CAMPFIRE_FIELD_NAME, Fire.Component.CAMPFIRE_BLOCK);
        FireResourceReloadListener.registerFire(fireType, builder.build());
    }

    private static void removeOrSet(String fireType, Fire.Builder builder, JsonObject data, String field, Fire.Component<?, ?> component) {
        if (data.get(field) != null && data.get(field).getAsString().equals("remove")) {
            builder.removeComponent(component);
        } else {
            String value = FireResourceReloadListener.parse(fireType, field, data, JsonElement::getAsString, null);
            if (value != null && class_2960.method_12829((String)value) != null) {
                builder.setComponent(component, class_2960.method_60654((String)value));
            }
        }
    }

    protected void apply(Map<class_2960, JsonElement> fires, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        FireResourceReloadListener.unregisterFires();
        for (Map.Entry<class_2960, JsonElement> fire : fires.entrySet()) {
            String jsonIdentifier = fire.getKey().method_12832();
            try {
                JsonObject jsonData = FireResourceReloadListener.getJsonObject(jsonIdentifier, fire.getValue());
                String mod = FireResourceReloadListener.parse(jsonIdentifier, "mod", jsonData, JsonElement::getAsString);
                if (Services.PLATFORM.isModLoaded(mod)) {
                    FireResourceReloadListener.parse(jsonIdentifier, "fires", jsonData, JsonElement::getAsJsonArray).forEach(element -> FireResourceReloadListener.registerFire(FireResourceReloadListener.getJsonObject(jsonIdentifier, element), mod, jsonIdentifier));
                    continue;
                }
                Constants.LOGGER.warn("Registering of ddfires for [{}] is canceled: {} is not loaded.", (Object)mod, (Object)mod);
            }
            catch (IllegalStateException | NullPointerException | NumberFormatException | UnsupportedOperationException e) {
                Constants.LOGGER.error("Registering of ddfires for [{}] is canceled.", (Object)jsonIdentifier);
            }
        }
    }
}

