/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.api.block;

import it.crystalnest.prometheus.api.FireManager;
import it.crystalnest.prometheus.api.type.FireTyped;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class CustomLanternBlock
extends LanternBlock
implements FireTyped {
    private final ResourceLocation fireType;

    public CustomLanternBlock(ResourceLocation fireType, BlockBehaviour.Properties properties) {
        this(fireType, true, properties);
    }

    public CustomLanternBlock(ResourceLocation fireType, boolean addDefaultProperties, BlockBehaviour.Properties properties) {
        super((addDefaultProperties ? CustomLanternBlock.addDefaultProperties(properties) : properties).lightLevel(state -> FireManager.light(fireType)));
        this.fireType = fireType;
    }

    private static BlockBehaviour.Properties addDefaultProperties(BlockBehaviour.Properties properties) {
        return properties.mapColor(MapColor.METAL).forceSolidOn().requiresCorrectToolForDrops().strength(3.5f).sound(SoundType.LANTERN).noOcclusion().pushReaction(PushReaction.DESTROY);
    }

    @Override
    public ResourceLocation getFireType() {
        return this.fireType;
    }
}

