/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.prometheus.api.client;

import it.crystalnest.prometheus.Constants;
import it.crystalnest.prometheus.api.Fire;
import it.crystalnest.prometheus.api.FireManager;
import it.crystalnest.prometheus.api.client.FireClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1058;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class FireClientManager {
    private static final ConcurrentHashMap<class_2960, FireClient> FIRES = new ConcurrentHashMap();

    private FireClientManager() {
    }

    @Nullable
    private static synchronized FireClient registerFire(FireClient fire) {
        if (FIRES.putIfAbsent(fire.getFireType(), fire) != null) {
            class_2960 fireType = fire.getFireType();
            Constants.LOGGER.error("FireClient [{}] was already registered with the following value: {}", (Object)fireType, (Object)FIRES.get(fireType));
            return null;
        }
        return fire;
    }

    @Nullable
    public static synchronized FireClient registerFire(Fire fire) {
        return FireClientManager.registerFire(new FireClient(fire.getFireType()));
    }

    public static synchronized Map<class_2960, @Nullable FireClient> registerFires(List<Fire> fires) {
        HashMap<class_2960, @Nullable FireClient> outcomes = new HashMap<class_2960, FireClient>();
        for (Fire fire : fires) {
            outcomes.put(fire.getFireType(), FireClientManager.registerFire(fire));
        }
        return outcomes;
    }

    public static synchronized Map<class_2960, @Nullable FireClient> registerFires(Fire ... fires) {
        return FireClientManager.registerFires(List.of(fires));
    }

    @Nullable
    @ApiStatus.Internal
    public static synchronized FireClient unregisterFire(class_2960 fireType) {
        return FIRES.remove(fireType);
    }

    public static class_4730 getMaterial0(class_2960 fireType) {
        if (FireManager.isRegisteredType(fireType) && FIRES.containsKey(fireType)) {
            return FIRES.get(fireType).getMaterial0();
        }
        return class_1088.field_5397;
    }

    public static class_4730 getMaterial1(class_2960 fireType) {
        if (FireManager.isRegisteredType(fireType) && FIRES.containsKey(fireType)) {
            return FIRES.get(fireType).getMaterial1();
        }
        return class_1088.field_5370;
    }

    public static class_1058 getSprite0(class_2960 fireType) {
        if (FireManager.isRegisteredType(fireType) && FIRES.containsKey(fireType)) {
            return FIRES.get(fireType).getSprite0();
        }
        return class_1088.field_5397.method_24148();
    }

    public static class_1058 getSprite1(class_2960 fireType) {
        if (FireManager.isRegisteredType(fireType) && FIRES.containsKey(fireType)) {
            return FIRES.get(fireType).getSprite1();
        }
        return class_1088.field_5370.method_24148();
    }
}

