/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.item;

import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9890;
import net.weather_classic.WeatherClassic;
import net.weather_classic.global.tools.TornadoDestructionInfo;
import net.weather_classic.help.Utils;
import net.weather_classic.item.WindCore;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.registry.WCItems;
import net.weather_classic.storm.debris.DebrisEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class DrillItem
extends class_1792 {
    private static final class_9279 C = class_9279.method_57456((class_2487)new class_2487());
    private final int maxTime;

    public DrillItem(class_1792.class_1793 settings) {
        super(settings);
        this.maxTime = 20;
    }

    public class_1269 method_7884(class_1838 context) {
        class_2680 state = context.method_8045().method_8320(context.method_8037());
        if (Utils.canPassThrough(state.method_26204())) {
            return class_1269.field_5814;
        }
        class_1657 user = context.method_8036();
        class_1799 itemStack = context.method_8041();
        user.method_6019(context.method_20287());
        Utils.playSound(null, context.method_8045(), user.method_24515(), class_3417.field_15197, class_3419.field_15248, 1.0f, 1.4f);
        this.setUsageTime(itemStack, this.maxTime);
        this.setPos(itemStack, context.method_8037());
        this.setStartPos(itemStack, context.method_8037());
        this.setAngle(itemStack, user.method_5828(1.0f).method_46409());
        if (context.method_8045().method_8608()) {
            for (int i = 0; i < 20; ++i) {
                context.method_8045().method_8406((class_2394)class_2398.field_11237, user.method_23322(5.0), user.method_23318() + 0.1, user.method_23325(5.0), 0.0, 0.4, 0.0);
            }
        }
        this.doDamage(context.method_8045(), itemStack, user);
        return class_1269.field_52422;
    }

    private void doDamage(class_1937 world, class_1799 stack, class_1657 player) {
        int amount = 5;
        boolean ub = stack.method_58657().method_57534().stream().anyMatch(p -> p.method_40225(class_1893.field_9119));
        if (ub) {
            amount = 2;
        }
        if (!world.method_8608() && !player.method_68878()) {
            if (player != null) {
                class_174.field_1185.method_8960((class_3222)player, stack, amount);
            }
            stack.method_7974(stack.method_7919() + amount);
            if (stack.method_58694(class_9334.field_53696) == null || stack.method_58694(class_9334.field_49639) == null) {
                stack.method_57379(class_9334.field_53696, (Object)new class_9890((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{WCItems.WEATHER_DEVICE.method_40131()})));
                stack.method_57379(class_9334.field_49639, (Object)11);
            }
        }
        if (!world.method_8608() && stack.method_7919() >= stack.method_7936() - 5) {
            class_1304 slot = class_1799.method_7973((class_1799)player.method_6047(), (class_1799)stack) ? class_1304.field_6173 : class_1304.field_6171;
            stack.method_7934(1);
            player.method_20235(stack.method_7909(), slot);
            return;
        }
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        int islot = ((class_1657)entity).method_31548().method_7395(stack);
        int usageTime = this.getUsageTime(stack, (class_1657)entity, islot);
        class_2338 pos = this.getPos(stack);
        Vector3f angle = this.getAngle(stack);
        class_2338 start = this.getStartPos(stack);
        if (usageTime > 0) {
            if (pos == null || angle == null) {
                this.setUsageTime(stack, 0);
                return;
            }
            if (entity.field_6012 % 8 == 0) {
                this.setUsageTime(stack, usageTime - 1);
                if (!world.method_8608()) {
                    this.serverTick(world, (class_1309)entity, angle, start, pos, usageTime, stack);
                }
            }
        } else if (pos != null || angle != null || start != null) {
            this.setPos(stack, Utils.effectivelyNull);
            this.setAngle(stack, null);
            this.setStartPos(stack, Utils.effectivelyNull);
        }
    }

    public void serverTick(class_3218 world, class_1309 entity, Vector3f rotationVec, class_2338 startingPos, class_2338 curPos, int curTime, class_1799 stack) {
        class_243 startPosVec = startingPos.method_46558();
        class_243 directionVec = new class_243((double)rotationVec.x, (double)rotationVec.y, (double)rotationVec.z).method_1029();
        float distance = (float)(this.maxTime - curTime) * 2.0f;
        class_243 nextPosVec = startPosVec.method_1019(directionVec.method_1021((double)distance));
        class_2338 nextPos = class_2338.method_49638((class_2374)nextPosVec);
        boolean foundGround = false;
        world.method_65096((class_2394)class_2398.field_11204, (double)nextPos.method_10263() + 0.5, (double)nextPos.method_10264() + 0.5, (double)nextPos.method_10260() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        for (class_2338 next : class_2338.method_10097((class_2338)nextPos.method_10069(-2, -1, -2), (class_2338)nextPos.method_10069(2, 1, 2))) {
            class_2680 state = world.method_8320(next);
            if (state.method_26215() || !TornadoDestructionInfo.canWindCoreGrab(state, WindCore.WindCoreLevel.STAGE5) && !state.method_27852(class_2246.field_10362) && !state.method_27852(class_2246.field_10194)) continue;
            foundGround = true;
            DebrisEntity debris = DebrisEntity.createDebris(WCEntities.DEBRIS, entity, state, true, (class_1937)world);
            debris.method_5725(next, 0.0f, 0.0f);
            world.method_8649((class_1297)debris);
            double mult = distance / 8.0f;
            debris.method_18800(directionVec.field_1352 * -(mult += 3.0), directionVec.field_1351 * -mult, directionVec.field_1350 * -mult);
            debris.setKnockbackInstead();
            debris.setDamageMultiplier(1.1);
            debris.field_5960 = true;
            world.method_8501(next, class_2246.field_10124.method_9564());
        }
        Utils.playSound(null, (class_1937)world, nextPos, WeatherClassic.BLOCK_LAUNCHER, class_3419.field_15248, 2.0f, 1.0f + world.method_8409().method_43057());
        if (!foundGround) {
            this.setUsageTime(stack, 0);
        }
        this.setPos(stack, nextPos);
    }

    public void setUsageTime(class_1799 stack, int time) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_10569("usage_time", time);
    }

    public int getUsageTime(class_1799 stack, class_1657 player, int islot) {
        int prevSlot;
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        if (islot != (prevSlot = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_68083("prev_slot", -1))) {
            ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_10569("prev_slot", islot);
            return 0;
        }
        int p = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_68083("usage_time", 0);
        return p;
    }

    public void setPos(class_1799 stack, class_2338 pos) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_10544("pos", pos.method_10063());
    }

    public class_2338 getPos(class_1799 stack) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        long l = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_68080("pos", Utils.effectivelyNull.method_10063());
        return Utils.effectivelyNull.method_10063() == l ? null : class_2338.method_10092((long)l);
    }

    public void setStartPos(class_1799 stack, class_2338 pos) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_10544("start_pos", pos.method_10063());
    }

    public class_2338 getStartPos(class_1799 stack) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        long l = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463().method_68080("start_pos", Utils.effectivelyNull.method_10063());
        return Utils.effectivelyNull.method_10063() == l ? null : class_2338.method_10092((long)l);
    }

    public void setAngle(class_1799 stack, Vector3f dir) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        class_2487 tag = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463();
        if (dir == null) {
            tag.method_10548("yaw", 0.0f);
            tag.method_10548("pitch", 0.0f);
            tag.method_10548("roll", 0.0f);
            return;
        }
        tag.method_10548("pitch", dir.x);
        tag.method_10548("yaw", dir.y);
        tag.method_10548("roll", dir.z);
    }

    public Vector3f getAngle(class_1799 stack) {
        if (stack.method_58694(WCItems.I_USE_TIME) == null) {
            stack.method_57379(WCItems.I_USE_TIME, (Object)class_9279.method_57456((class_2487)new class_2487()));
        }
        class_2487 tag = ((class_9279)stack.method_58694(WCItems.I_USE_TIME)).method_57463();
        float yaw = tag.method_66563("yaw", 0.0f);
        float pitch = tag.method_66563("pitch", 0.0f);
        float roll = tag.method_66563("roll", 0.0f);
        if (yaw == 0.0f && pitch == 0.0f && roll == 0.0f) {
            return null;
        }
        return new Vector3f(pitch, yaw, roll);
    }
}

